/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usersadmin.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.Address;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.AddressLocalServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;

public class AddressStagedModelDataHandler
extends BaseStagedModelDataHandler<Address> {
    public static final String[] CLASS_NAMES = new String[]{Address.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException, SystemException {
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        Address address = AddressLocalServiceUtil.fetchAddressByUuidAndCompanyId((String)uuid, (long)group.getCompanyId());
        if (address != null) {
            AddressLocalServiceUtil.deleteAddress((Address)address);
        }
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, Address address) throws Exception {
        Element addressElement = portletDataContext.getExportDataElement((ClassedModel)address);
        portletDataContext.addClassedModel(addressElement, ExportImportPathUtil.getModelPath((StagedModel)address), (ClassedModel)address);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, Address address) throws Exception {
        long userId = portletDataContext.getUserId(address.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)address);
        Address existingAddress = AddressLocalServiceUtil.fetchAddressByUuidAndCompanyId((String)address.getUuid(), (long)portletDataContext.getCompanyId());
        Address importedAddress = null;
        if (existingAddress == null) {
            serviceContext.setUuid(address.getUuid());
            importedAddress = AddressLocalServiceUtil.addAddress((long)userId, (String)address.getClassName(), (long)address.getClassPK(), (String)address.getStreet1(), (String)address.getStreet2(), (String)address.getStreet3(), (String)address.getCity(), (String)address.getZip(), (long)address.getRegionId(), (long)address.getCountryId(), (int)address.getTypeId(), (boolean)address.getMailing(), (boolean)address.isPrimary(), (ServiceContext)serviceContext);
        } else {
            importedAddress = AddressLocalServiceUtil.updateAddress((long)existingAddress.getAddressId(), (String)address.getStreet1(), (String)address.getStreet2(), (String)address.getStreet3(), (String)address.getCity(), (String)address.getZip(), (long)address.getRegionId(), (long)address.getCountryId(), (int)address.getTypeId(), (boolean)address.getMailing(), (boolean)address.isPrimary());
        }
        portletDataContext.importClassedModel((ClassedModel)address, (ClassedModel)importedAddress);
    }
}

