/*
 * Decompiled with CFR 0.152.
 */
package jodd.decora;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.decora.DecoraManager;
import jodd.servlet.wrapper.BufferResponseWrapper;
import jodd.servlet.wrapper.LastModifiedData;

public class DecoraResponseWrapper
extends BufferResponseWrapper {
    protected final DecoraManager decoraManager;
    protected final HttpServletRequest request;
    protected final HttpServletResponse response;

    public DecoraResponseWrapper(HttpServletRequest originalRequest, HttpServletResponse originalResponse, LastModifiedData lastModifiedData, DecoraManager decoraManager) {
        super(originalResponse, lastModifiedData);
        this.request = originalRequest;
        this.response = originalResponse;
        this.decoraManager = decoraManager;
    }

    protected boolean bufferContentType(String contentType, String mimeType, String encoding) {
        return this.decoraManager.decorateContentType(contentType, mimeType, encoding);
    }

    protected boolean bufferStatusCode(int statusCode) {
        return this.decoraManager.decorateStatusCode(statusCode);
    }

    protected void preResponseCommit() {
        long lastModified = this.lastModifiedData.getLastModified();
        long ifModifiedSince = this.request.getDateHeader("If-Modified-Since");
        if (lastModified > -1L && !this.response.containsHeader("Last-Modified")) {
            if (ifModifiedSince < lastModified / 1000L * 1000L) {
                this.response.setDateHeader("Last-Modified", lastModified);
            } else {
                this.response.reset();
                this.response.setStatus(304);
            }
        }
    }
}

