/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.context.application;

import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletContext;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.client.proxy.AuthorizationProxy;
import org.gcube.common.events.Hub;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.smartgears.configuration.application.ApplicationConfiguration;
import org.gcube.smartgears.context.Properties;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.context.container.ContainerContext;
import org.gcube.smartgears.lifecycle.application.ApplicationLifecycle;
import org.gcube.smartgears.persistence.Persistence;

public class DefaultApplicationContext
implements ApplicationContext {
    private final ContainerContext container;
    private final ServletContext sctx;
    private final ApplicationConfiguration configuration;
    private final ApplicationLifecycle lifecycle;
    private final Properties properties;
    private final Hub hub;
    private Map<String, String> authorizationTokenMap;

    public DefaultApplicationContext(ContainerContext container, ServletContext sctx, ApplicationConfiguration configuration, Hub hub, ApplicationLifecycle lifecycle, Properties properties) {
        this.container = container;
        this.sctx = sctx;
        this.configuration = configuration;
        this.hub = hub;
        this.lifecycle = lifecycle;
        this.properties = properties;
    }

    public DefaultApplicationContext(ApplicationContext context) {
        this(context.container(), context.application(), context.configuration(), context.events(), context.lifecycle(), new Properties(context.properties()));
    }

    @Override
    public ServletContext application() {
        return this.sctx;
    }

    @Override
    public ContainerContext container() {
        return this.container;
    }

    @Override
    public <T> T profile(Class<T> type) {
        if (type == GCoreEndpoint.class) {
            return (T)this.properties().lookup("endpoint-profile").value(GCoreEndpoint.class);
        }
        throw new IllegalArgumentException("unsupported profile type: " + type);
    }

    @Override
    public String name() {
        return this.configuration.name();
    }

    @Override
    public ApplicationConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public ApplicationLifecycle lifecycle() {
        return this.lifecycle;
    }

    @Override
    public Hub events() {
        return this.hub;
    }

    @Override
    public Persistence persistence() {
        return this.configuration.persistence();
    }

    @Override
    public Properties properties() {
        return this.properties;
    }

    @Override
    public String authorizationToken() {
        if (!this.authorizationTokenMap.containsKey(ScopeProvider.instance.get())) {
            String token = ((AuthorizationProxy)Constants.authorizationService().build()).generate(this.configuration().serviceClass() + "/" + this.configuration().name(), new ArrayList(0));
            this.authorizationTokenMap.put(ScopeProvider.instance.get(), token);
        }
        return this.authorizationTokenMap.get(ScopeProvider.instance.get());
    }
}

