/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.persistence;

import java.io.File;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import org.gcube.documentstore.persistence.DefaultPersitenceExecutor;
import org.gcube.documentstore.persistence.FallbackPersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackendConfiguration;
import org.gcube.documentstore.records.RecordUtility;
import org.gcube.documentstore.records.aggregation.AggregationScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PersistenceBackendFactory {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceBackendFactory.class);
    public static final String DEFAULT_CONTEXT = "DEFAULT_CONTEXT";
    public static final String HOME_SYSTEM_PROPERTY = "user.home";
    protected static final String FALLBACK_FILENAME = "fallback.log";
    private static String fallbackLocation;
    private static Map<String, PersistenceBackend> persistenceBackends;
    private static Map<String, Long> fallbackLastCheck;
    public static final long FALLBACK_RETRY_TIME = 600000L;

    protected static Long getFallbackLastCheck(String scope) {
        return fallbackLastCheck.get(scope);
    }

    public static void addRecordPackage(Package packageObject) {
        RecordUtility.addRecordPackage(packageObject);
    }

    private static File file(File file) throws IllegalArgumentException {
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static synchronized void setFallbackLocation(String path) {
        if (fallbackLocation == null) {
            if (path == null) {
                path = System.getProperty(HOME_SYSTEM_PROPERTY);
            }
            PersistenceBackendFactory.file(new File(path));
            fallbackLocation = path;
        }
    }

    protected static synchronized String getFallbackLocation() {
        if (fallbackLocation == null) {
            try {
                return System.getProperty(HOME_SYSTEM_PROPERTY);
            }
            catch (Exception e) {
                return ".";
            }
        }
        return fallbackLocation;
    }

    protected static String sanitizeContext(String context) {
        if (context == null || context.compareTo("") == 0) {
            return DEFAULT_CONTEXT;
        }
        return context;
    }

    protected static String removeSlashFromContext(String context) {
        return context.replace("/", "_");
    }

    public static File getFallbackFile(String context) {
        context = PersistenceBackendFactory.sanitizeContext(context);
        String slashLessContext = PersistenceBackendFactory.removeSlashFromContext(context);
        File fallbackFile = new File(PersistenceBackendFactory.getFallbackLocation(), String.format("%s.%s", slashLessContext, FALLBACK_FILENAME));
        return fallbackFile;
    }

    protected static FallbackPersistenceBackend createFallback(String context) {
        context = PersistenceBackendFactory.sanitizeContext(context);
        logger.debug("Creating {} for context {}", (Object)FallbackPersistenceBackend.class.getSimpleName(), (Object)context);
        File fallbackFile = PersistenceBackendFactory.getFallbackFile(context);
        logger.trace("{} for context {} is {}", new Object[]{FallbackPersistenceBackend.class.getSimpleName(), context, fallbackFile.getAbsolutePath()});
        FallbackPersistenceBackend fallbackPersistence = new FallbackPersistenceBackend(fallbackFile);
        fallbackPersistence.setAggregationScheduler(AggregationScheduler.newInstance(new DefaultPersitenceExecutor(fallbackPersistence)));
        return fallbackPersistence;
    }

    protected static PersistenceBackend discoverPersistenceBackend(String context) {
        context = PersistenceBackendFactory.sanitizeContext(context);
        logger.debug("Discovering {} for scope {}", (Object)PersistenceBackend.class.getSimpleName(), (Object)context);
        ServiceLoader<PersistenceBackend> serviceLoader = ServiceLoader.load(PersistenceBackend.class);
        for (PersistenceBackend found : serviceLoader) {
            Class<?> foundClass = found.getClass();
            try {
                String foundClassName = foundClass.getSimpleName();
                logger.debug("Testing {}", (Object)foundClassName);
                PersistenceBackendConfiguration configuration = PersistenceBackendConfiguration.getInstance(foundClass);
                if (configuration == null) continue;
                found.prepareConnection(configuration);
                logger.debug("{} will be used.", (Object)foundClassName);
                found.setAggregationScheduler(AggregationScheduler.newInstance(new DefaultPersitenceExecutor(found)));
                found.setFallback(PersistenceBackendFactory.createFallback(context));
                return found;
            }
            catch (Exception e) {
                logger.error(String.format("%s not initialized correctly. It will not be used. Trying the next one if any.", foundClass.getSimpleName()), (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static PersistenceBackend rediscoverPersistenceBackend(PersistenceBackend actual, String context) {
        context = PersistenceBackendFactory.sanitizeContext(context);
        Long now = Calendar.getInstance().getTimeInMillis();
        Long lastCheckTimestamp = fallbackLastCheck.get(context);
        logger.debug("Last check for context {} was {}", (Object)context, (Object)lastCheckTimestamp);
        boolean myTurn = false;
        Map<String, PersistenceBackend> map = persistenceBackends;
        synchronized (map) {
            if (lastCheckTimestamp + 600000L <= now) {
                logger.debug("The {} for context {} is {}. Is time to rediscover if there is another possibility.", new Object[]{PersistenceBackend.class.getSimpleName(), context, actual.getClass().getSimpleName()});
                logger.trace("Renewing Last check Timestamp. The next one will be {}", (Object)now);
                fallbackLastCheck.put(context, now);
                myTurn = true;
                logger.debug("I win. It is my turn to rediscover {} in context {}", (Object)PersistenceBackend.class.getSimpleName(), (Object)context);
            }
        }
        if (myTurn) {
            PersistenceBackend discoveredPersistenceBackend = PersistenceBackendFactory.discoverPersistenceBackend(context);
            Map<String, PersistenceBackend> map2 = persistenceBackends;
            synchronized (map2) {
                if (discoveredPersistenceBackend != null) {
                    discoveredPersistenceBackend.setAggregationScheduler(actual.getAggregationScheduler());
                    fallbackLastCheck.remove(context);
                    persistenceBackends.put(context, discoveredPersistenceBackend);
                    return discoveredPersistenceBackend;
                }
            }
        }
        long nextCheck = lastCheckTimestamp + 600000L - Calendar.getInstance().getTimeInMillis();
        float nextCheckInSec = nextCheck / 1000L;
        logger.debug("The {} for context {} is going to be used is {}. Next retry in {} msec (about {} sec)", new Object[]{PersistenceBackend.class.getSimpleName(), context, actual.getClass().getSimpleName(), nextCheck, Float.valueOf(nextCheckInSec)});
        return actual;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PersistenceBackend getPersistenceBackend(String context) {
        context = PersistenceBackendFactory.sanitizeContext(context);
        PersistenceBackend persistence = null;
        logger.debug("Going to synchronized block in getPersistenceBackend");
        Map<String, PersistenceBackend> map = persistenceBackends;
        synchronized (map) {
            persistence = persistenceBackends.get(context);
            logger.debug("{} {}", (Object)PersistenceBackend.class.getSimpleName(), (Object)persistence);
            if (persistence == null) {
                persistence = PersistenceBackendFactory.createFallback(context);
                persistenceBackends.put(context, persistence);
                long now = Calendar.getInstance().getTimeInMillis();
                try {
                    Class.forName("org.gcube.informationsystem.collector.impl.utils.Identifier");
                    fallbackLastCheck.put(context, now);
                }
                catch (ClassNotFoundException e) {
                    fallbackLastCheck.put(context, now - 600000L - 1L);
                }
            }
        }
        if (persistence instanceof FallbackPersistenceBackend) {
            persistence = PersistenceBackendFactory.rediscoverPersistenceBackend(persistence, context);
        }
        return persistence;
    }

    public static void flush(String context, long timeout, TimeUnit timeUnit) {
        context = PersistenceBackendFactory.sanitizeContext(context);
        PersistenceBackend apb = persistenceBackends.get(context);
        try {
            logger.debug("Flushing records in context {}", (Object)context);
            apb.flush(timeout, timeUnit);
        }
        catch (Exception e) {
            logger.error("Unable to flush records in context {} with {}", new Object[]{context, apb, e});
        }
    }

    public static void flushAll(long timeout, TimeUnit timeUnit) {
        for (String context : persistenceBackends.keySet()) {
            PersistenceBackendFactory.flush(context, timeout, timeUnit);
        }
    }

    static {
        persistenceBackends = new HashMap<String, PersistenceBackend>();
        fallbackLastCheck = new HashMap<String, Long>();
    }
}

