/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregator;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.gcube.accounting.datamodel.validations.validators.RegexReplace;
import org.gcube.accounting.persistence.AccountingPersistenceConfiguration;
import org.gcube.documentstore.records.DSMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexRulesAggregator
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(RegexRulesAggregator.class);
    private static final ScheduledExecutorService REGEX_REDISCOVERY_POOL = Executors.newScheduledThreadPool(50, new ThreadFactory(){
        private int counter = 0;
        private static final String prefix = "RegexRediscoveryThread";

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "RegexRediscoveryThread-" + this.counter++);
        }
    });
    protected TimeUnit timeUnit = TimeUnit.MINUTES;
    protected long delay = TimeUnit.MINUTES.toMinutes(15L);
    protected static final String DELAY = "delay";
    protected static final String TIME_UNIT = "timeUnit";
    protected static final String JSON_ARRAY_CALLED_METHOD_RULES = "jsonArrayCalledMethodRules";
    protected ScheduledFuture<?> rulesReloader;
    protected List<RegexReplace> regexReplaceList = new ArrayList<RegexReplace>();
    protected AccountingPersistenceConfiguration accountingPersistenceConfiguration;
    protected static RegexRulesAggregator instance;
    protected ScheduledFuture<?> reloadAggregatorRules;

    public static synchronized RegexRulesAggregator getInstance() {
        if (instance == null) {
            instance = new RegexRulesAggregator();
        }
        return instance;
    }

    protected RegexRulesAggregator() {
        this.readConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RegexReplace> getRegexReplaceList() {
        List<RegexReplace> list = this.regexReplaceList;
        synchronized (list) {
            return this.regexReplaceList;
        }
    }

    public RegexReplace addRegexReplace(String serviceClass, String serviceName, String regex, String replace) {
        RegexReplace regexReplace = new RegexReplace(serviceClass, serviceName, regex, replace);
        return this.addRegexReplace(regexReplace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegexReplace addRegexReplace(RegexReplace regexReplace) {
        List<RegexReplace> list = this.regexReplaceList;
        synchronized (list) {
            this.regexReplaceList.add(regexReplace);
        }
        return regexReplace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfiguration() {
        try {
            this.accountingPersistenceConfiguration = new AccountingPersistenceConfiguration(this.getClass());
            try {
                String delayString = this.accountingPersistenceConfiguration.getProperty(DELAY);
                this.delay = Long.parseLong(delayString);
                String timeUnitString = this.accountingPersistenceConfiguration.getProperty(TIME_UNIT);
                this.timeUnit = TimeUnit.valueOf(timeUnitString.toUpperCase());
            }
            catch (Exception e) {
                logger.warn("Unable to retrieve regex reload delay. Goign to use last known delay {} {}", (Object)this.delay, (Object)this.timeUnit.name().toLowerCase());
            }
            String rulesString = this.accountingPersistenceConfiguration.getProperty(JSON_ARRAY_CALLED_METHOD_RULES);
            ObjectMapper mapper = DSMapper.getObjectMapper();
            CollectionType type = mapper.getTypeFactory().constructCollectionType(List.class, RegexReplace.class);
            List rules = (List)mapper.readValue(rulesString, (JavaType)type);
            List<RegexReplace> list = this.regexReplaceList;
            synchronized (list) {
                this.regexReplaceList = rules;
            }
        }
        catch (Exception e) {
            logger.error("Unable to properly load RegexRules", (Throwable)e);
        }
    }

    @Override
    public void run() {
        this.readConfiguration();
    }

    public void start() {
        if (this.reloadAggregatorRules == null) {
            this.reloadAggregatorRules = REGEX_REDISCOVERY_POOL.scheduleAtFixedRate(this, this.delay, this.delay, this.timeUnit);
        }
    }

    public void stop() {
        if (this.reloadAggregatorRules != null) {
            try {
                this.reloadAggregatorRules.cancel(true);
                this.reloadAggregatorRules = null;
            }
            catch (Throwable t) {
                logger.error("Unable to properly stop {} reloader", (Object)this.getClass().getSimpleName(), (Object)t);
            }
        }
    }
}

