/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.utils;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;

public final class UUIDManager {
    public static final Set<String> RESERVED_UUID_STRING;
    public static final Set<UUID> RESERVED_UUID;

    private UUIDManager() {
    }

    public static boolean isReservedUUID(UUID uuid) {
        return RESERVED_UUID.contains(uuid);
    }

    public static boolean isReservedUUID(String uuid) {
        return RESERVED_UUID_STRING.contains(uuid);
    }

    public static Set<String> getAllReservedUUIDAsStrings() {
        return new TreeSet<String>(RESERVED_UUID_STRING);
    }

    public static Set<UUID> getAllReservedUUID() {
        return new TreeSet<UUID>(RESERVED_UUID);
    }

    public static UUID generateValidRandomUUID() {
        UUID generated = UUID.randomUUID();
        while (RESERVED_UUID.contains(generated)) {
            generated = UUID.randomUUID();
        }
        return generated;
    }

    static {
        String[] uuidValidCharacters;
        RESERVED_UUID_STRING = new HashSet<String>();
        RESERVED_UUID = new HashSet<UUID>();
        for (String string : uuidValidCharacters = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"}) {
            String uuidString = "XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX";
            uuidString = uuidString.replaceAll("X", string);
            RESERVED_UUID_STRING.add(uuidString);
            RESERVED_UUID.add(UUID.fromString(uuidString));
        }
    }
}

