/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handlers.container.lifecycle;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.gcube.common.events.Observes;
import org.gcube.smartgears.configuration.Mode;
import org.gcube.smartgears.context.Property;
import org.gcube.smartgears.context.container.ContainerContext;
import org.gcube.smartgears.handlers.container.ContainerHandler;
import org.gcube.smartgears.handlers.container.ContainerLifecycleEvent;
import org.gcube.smartgears.lifecycle.container.ContainerLifecycle;
import org.gcube.smartgears.lifecycle.container.ContainerState;
import org.gcube.smartgears.provider.ProviderFactory;
import org.gcube.smartgears.publishing.Publisher;
import org.gcube.smartgears.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerProfileManager
extends ContainerHandler {
    Logger log = LoggerFactory.getLogger(ContainerProfileManager.class);
    private ContainerContext context;
    private ScheduledFuture<?> periodicUpdates;
    private static final String PUBLISHED_PROP = "published";
    private List<Publisher> publishers;

    @Override
    public void onStart(ContainerLifecycleEvent.Start e) {
        this.context = (ContainerContext)e.context();
        this.activated();
    }

    private void activated() {
        this.publishers = this.context.configuration().mode() != Mode.offline ? ProviderFactory.provider().publishers() : Collections.emptyList();
        this.registerObservers();
        this.schedulePeriodicUpdates();
    }

    private void registerObservers() {
        this.context.events().subscribe(new Object(){

            @Observes(value={"activation", "part_activation", "shutdown", "stop", "failure"})
            void onChanged(ContainerLifecycle lc) {
                ContainerProfileManager.this.context.events().fire((Object)ContainerProfileManager.this.context, new String[]{"changed"});
            }

            @Observes(value={"changed"}, kind=Observes.Kind.critical)
            void publishAfterChange(ContainerContext context) {
                ContainerProfileManager.this.log.info("Publish after profile Change event called");
                if (!context.properties().contains(ContainerProfileManager.PUBLISHED_PROP)) {
                    context.properties().add(new Property(ContainerProfileManager.PUBLISHED_PROP, true));
                    ContainerProfileManager.this.log.info("publishing container for the first time");
                    if (context.lifecycle().state() != ContainerState.failed) {
                        ContainerProfileManager.this.publishers.forEach(p -> {
                            try {
                                p.create(context, context.configuration().authorizationProvider().getContexts());
                            }
                            catch (Exception e) {
                                ContainerProfileManager.this.log.error("cannot publish container for first time with publisher type {} (see details)", (Object)p.getClass().getCanonicalName(), (Object)e);
                            }
                        });
                    }
                } else {
                    ContainerProfileManager.this.publishers.forEach(p -> {
                        try {
                            p.update(context);
                        }
                        catch (Exception e) {
                            ContainerProfileManager.this.log.error("cannot publish container with publisher type {} (see details)", (Object)p.getClass().getCanonicalName(), (Object)e);
                        }
                    });
                }
            }

            @Observes(value={"addToContext"})
            void addTo(String scope) {
                for (Publisher publisher : ContainerProfileManager.this.publishers) {
                    try {
                        ContainerProfileManager.this.log.trace("publishing container within new scope");
                        publisher.create(ContainerProfileManager.this.context, Collections.singleton(scope));
                    }
                    catch (Exception e) {
                        ContainerProfileManager.this.log.error("cannot add container to {} with publisher type {} (see details)", new Object[]{scope, publisher.getClass().getCanonicalName(), e});
                    }
                }
            }

            @Observes(value={"removeFromContext"})
            void removeFrom(String scope) {
                for (Publisher publisher : ContainerProfileManager.this.publishers) {
                    try {
                        ContainerProfileManager.this.log.trace("unpublishing container from context {}", (Object)scope);
                        publisher.remove(ContainerProfileManager.this.context, Collections.singleton(scope));
                    }
                    catch (Exception e) {
                        ContainerProfileManager.this.log.error("cannot add container to {} with publisher type {} (see details)", new Object[]{scope, publisher.getClass().getCanonicalName(), e});
                    }
                }
            }
        });
    }

    private void schedulePeriodicUpdates() {
        this.context.events().subscribe(new Object(){

            @Observes(value={"activation", "part_activation"}, kind=Observes.Kind.resilient)
            synchronized void restartPeriodicUpdates(ContainerLifecycle lc) {
                if (ContainerProfileManager.this.periodicUpdates != null) {
                    return;
                }
                if (lc.state() == ContainerState.active) {
                    ContainerProfileManager.this.log.info("scheduling periodic updates of container profile");
                } else {
                    ContainerProfileManager.this.log.info("resuming periodic updates of container profile");
                }
                Runnable updateTask = new Runnable(){

                    @Override
                    public void run() {
                        ContainerProfileManager.this.context.events().fire((Object)ContainerProfileManager.this.context, new String[]{"changed"});
                    }
                };
                ContainerProfileManager.this.periodicUpdates = Utils.scheduledServicePool.scheduleAtFixedRate(updateTask, 3L, ContainerProfileManager.this.context.configuration().publicationFrequency(), TimeUnit.SECONDS);
            }

            @Observes(value={"stop", "failure", "shutdown"}, kind=Observes.Kind.resilient)
            synchronized void cancelPeriodicUpdates(ContainerLifecycle ignore) {
                if (ContainerProfileManager.this.periodicUpdates != null) {
                    ContainerProfileManager.this.log.trace("stopping periodic updates of container profile");
                    try {
                        ContainerProfileManager.this.periodicUpdates.cancel(true);
                        ContainerProfileManager.this.periodicUpdates = null;
                    }
                    catch (Exception e) {
                        ContainerProfileManager.this.log.warn("could not stop periodic updates of container profile", (Throwable)e);
                    }
                }
            }
        });
    }

    @Override
    public String toString() {
        return "profile-management";
    }
}

