/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.security.renewal;

import java.net.URL;
import org.gcube.common.keycloak.KeycloakClientFactory;
import org.gcube.common.keycloak.model.TokenResponse;
import org.gcube.common.security.renewal.RenewalProvider;
import org.gcube.common.security.secrets.JWTSecret;
import org.gcube.common.security.secrets.Secret;

public class ClientIDManager
implements RenewalProvider {
    protected final String clientID;
    protected final String clientSecret;
    protected final URL endpoint;

    public ClientIDManager(String clientID, String clientSecret, URL endpoint) {
        this.clientID = clientID;
        this.clientSecret = clientSecret;
        this.endpoint = endpoint;
    }

    public Secret getSecret() throws Exception {
        TokenResponse tokenResponse = KeycloakClientFactory.newInstance().queryUMAToken(this.endpoint, this.clientID, this.clientSecret, null);
        JWTSecret jwtSecret = new JWTSecret(tokenResponse.getAccessToken());
        jwtSecret.setRenewalProvider(this);
        jwtSecret.setTokenResponse(tokenResponse);
        return jwtSecret;
    }

    public Secret getSecret(String context) throws Exception {
        TokenResponse tokenResponse = KeycloakClientFactory.newInstance().queryUMAToken(this.endpoint, this.clientID, this.clientSecret, context, null);
        JWTSecret jwtSecret = new JWTSecret(tokenResponse.getAccessToken());
        jwtSecret.setRenewalProvider(this);
        jwtSecret.setTokenResponse(tokenResponse);
        return jwtSecret;
    }

    @Override
    public Secret renew() throws Exception {
        return this.getSecret();
    }
}

