/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.security.secrets;

import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.common.keycloak.model.AccessToken;
import org.gcube.common.keycloak.model.ModelUtils;
import org.gcube.common.keycloak.model.RefreshToken;
import org.gcube.common.keycloak.model.TokenResponse;
import org.gcube.common.keycloak.model.util.Time;
import org.gcube.common.security.Owner;
import org.gcube.common.security.renewal.RenewalProvider;
import org.gcube.common.security.secrets.GCubeJWTObject;
import org.gcube.common.security.secrets.Secret;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTSecret
extends Secret {
    private static final Logger logger = LoggerFactory.getLogger(JWTSecret.class);
    public static final long TOLERANCE = TimeUnit.MILLISECONDS.toMillis(200L);
    protected String jwtToken;
    protected AccessToken accessToken;
    protected TokenResponse tokenResponse;
    protected RenewalProvider renewalProvider;
    protected Owner owner;
    protected String context;
    protected boolean initialised = false;

    public JWTSecret(String jwtToken) {
        this.jwtToken = jwtToken;
    }

    private String getTokenString() {
        try {
            boolean expired = false;
            this.getAccessToken();
            if (Time.currentTimeMillis() >= this.accessToken.getExp() - TOLERANCE) {
                expired = true;
                if (this.tokenResponse != null) {
                    try {
                        expired = false;
                    }
                    catch (Exception e) {
                        logger.warn("Unable to refresh the token with RefreshToken. Going to try to renew it if possible.", (Throwable)e);
                    }
                }
            }
            if (expired && this.renewalProvider != null) {
                try {
                    JWTSecret renewed = (JWTSecret)this.renewalProvider.renew();
                    this.jwtToken = renewed.jwtToken;
                    this.accessToken = this.getAccessToken();
                }
                catch (Exception e) {
                    logger.warn("Unable to renew the token with the RenewalProvider. I'll continue using the old token.", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error("Unexpected error in the procedure to evaluate/refresh the current token. I'll continue using the old token.", (Throwable)e);
        }
        return this.jwtToken;
    }

    protected AccessToken getAccessToken() {
        if (this.accessToken == null) {
            String realUmaTokenEncoded = this.jwtToken.split("\\.")[1];
            String realUmaToken = new String(Base64.getDecoder().decode(realUmaTokenEncoded.getBytes()));
            ObjectMapper mapper = new ObjectMapper();
            try {
                this.accessToken = (AccessToken)mapper.readValue(realUmaToken, AccessToken.class);
            }
            catch (Exception e) {
                logger.error("Error parsing JWT token", (Throwable)e);
                throw new RuntimeException("Error parsing JWT token", e);
            }
        }
        return this.accessToken;
    }

    private synchronized void init() {
        if (!this.initialised) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                String accessTokenString = objectMapper.writeValueAsString((Object)this.getAccessToken());
                GCubeJWTObject obj = (GCubeJWTObject)objectMapper.readValue(accessTokenString, GCubeJWTObject.class);
                Owner owner = new Owner(obj.getUsername(), obj.getRoles(), obj.getEmail(), obj.getFirstName(), obj.getLastName(), obj.isExternalService());
                owner.setClientName(obj.getClientName());
                owner.setContactOrganisation(obj.getContactOrganisation());
                owner.setClientName(obj.getClientName());
                this.context = obj.getContext();
                this.initialised = true;
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
        }
    }

    public Owner getOwner() {
        this.init();
        return this.owner;
    }

    public String getContext() {
        this.init();
        return this.context;
    }

    public Map<String, String> getHTTPAuthorizationHeaders() {
        HashMap<String, String> authorizationHeaders = new HashMap<String, String>();
        authorizationHeaders.put("Authorization", "Bearer " + this.getTokenString());
        return authorizationHeaders;
    }

    public void setRenewalProvider(RenewalProvider renewalProvider) {
        this.renewalProvider = renewalProvider;
    }

    public void setTokenResponse(TokenResponse tokenResponse) {
        this.tokenResponse = tokenResponse;
    }

    protected boolean isExpired(AccessToken accessToken) {
        return Time.currentTimeMillis() > accessToken.getExp();
    }

    public boolean isExpired() {
        return this.isExpired(this.getAccessToken());
    }

    public boolean isRefreshable() {
        if (this.tokenResponse != null) {
            try {
                RefreshToken refreshToken = ModelUtils.getRefreshTokenFrom((TokenResponse)this.tokenResponse);
                return this.isExpired((AccessToken)refreshToken);
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }
}

