/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.publisher.is.legacy.application;

import java.net.URI;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import javax.servlet.ServletRegistration;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.smartgears.configuration.ProxyAddress;
import org.gcube.smartgears.configuration.application.ApplicationConfiguration;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.lifecycle.application.ApplicationState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationProfileBuilder {
    private static List<String> servletExcludes = Arrays.asList("default", "jsp");
    private static final Logger log = LoggerFactory.getLogger(ApplicationProfileBuilder.class);
    private ApplicationContext context;

    public ApplicationProfileBuilder(ApplicationContext context) {
        this.context = context;
    }

    public GCoreEndpoint create() {
        String baseAddress;
        GCoreEndpoint endpoint = new GCoreEndpoint();
        endpoint.setId(this.context.id());
        ApplicationConfiguration configuration = this.context.configuration();
        ContainerConfiguration container = this.context.container().configuration();
        endpoint.profile().description(configuration.description()).serviceName(configuration.name()).serviceClass(configuration.serviceClass()).version(configuration.version()).serviceId(configuration.name() + configuration.serviceClass() + configuration.version()).ghnId(this.context.container().id());
        endpoint.profile().newDeploymentData().activationTime(Calendar.getInstance()).status(((ApplicationState)this.context.lifecycle().state()).remoteForm());
        log.debug("publishing aplication profile with id {} for {} with status {}", new Object[]{this.context.id(), configuration.name(), ((ApplicationState)this.context.lifecycle().state()).remoteForm()});
        endpoint.profile().endpoints().clear();
        if (configuration.proxyAddress() != null) {
            ProxyAddress proxy = configuration.proxyAddress();
            String protocol = proxy.getProtocol();
            String port = proxy.getPort() != null ? ":" + proxy.getPort() : "";
            baseAddress = String.format("%s://%s%s%s", protocol, proxy.getHostname(), port, this.context.application().getContextPath());
        } else {
            String protocol = container.protocol();
            int port = container.port();
            baseAddress = String.format("%s://%s:%d%s", protocol, container.hostname(), port, this.context.application().getContextPath());
        }
        for (ServletRegistration servlet : this.context.application().getServletRegistrations().values()) {
            if (servletExcludes.contains(servlet.getName())) continue;
            for (String mapping : servlet.getMappings()) {
                String address = baseAddress + (mapping.endsWith("*") ? mapping.substring(0, mapping.length() - 2) : mapping);
                ((GCoreEndpoint.Profile.Endpoint)endpoint.profile().endpoints().add()).nameAndAddress(servlet.getName(), URI.create(address));
            }
        }
        return endpoint;
    }
}

