/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.security.secrets;

import java.util.Map;
import org.gcube.common.keycloak.KeycloakClient;
import org.gcube.common.keycloak.KeycloakClientFactory;
import org.gcube.common.keycloak.model.TokenResponse;
import org.gcube.common.security.Owner;
import org.gcube.common.security.secrets.AccessTokenSecret;
import org.gcube.common.security.secrets.Secret;

public class CredentialSecret
extends Secret {
    protected boolean initialised = false;
    private String username;
    private String password;
    private String context;
    private AccessTokenSecret accessTokenSecret;

    public CredentialSecret(String username, String password, String context) {
        this.username = username;
        this.password = password;
        this.context = context;
        this.init();
    }

    private void init() {
        this.refreshAccessToken();
    }

    private void refreshAccessToken() {
        try {
            KeycloakClient client = KeycloakClientFactory.newInstance();
            TokenResponse response = client.queryUMAToken(this.context, this.username, this.password, this.context, null);
            this.accessTokenSecret = new AccessTokenSecret(response.getAccessToken());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Owner getOwner() {
        return this.accessTokenSecret.getOwner();
    }

    public String getContext() {
        if (this.accessTokenSecret.isExpired()) {
            this.refreshAccessToken();
        }
        return this.accessTokenSecret.getContext();
    }

    public Map<String, String> getHTTPAuthorizationHeaders() {
        if (this.accessTokenSecret.isExpired()) {
            this.refreshAccessToken();
        }
        return this.accessTokenSecret.getHTTPAuthorizationHeaders();
    }

    public boolean isExpired() {
        return false;
    }
}

