/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handlers.application.request;

import java.util.Set;
import org.gcube.common.keycloak.KeycloakClient;
import org.gcube.common.keycloak.KeycloakClientException;
import org.gcube.common.keycloak.KeycloakClientFactory;
import org.gcube.common.security.ContextBean;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.AccessTokenSecret;
import org.gcube.common.security.secrets.GCubeSecret;
import org.gcube.common.security.secrets.Secret;
import org.gcube.smartgears.configuration.Mode;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.handlers.application.RequestEvent;
import org.gcube.smartgears.handlers.application.RequestHandler;
import org.gcube.smartgears.handlers.application.ResponseEvent;
import org.gcube.smartgears.handlers.application.request.RequestError;
import org.gcube.smartgears.lifecycle.application.ApplicationState;
import org.gcube.smartgears.security.SimpleCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestValidator
extends RequestHandler {
    private static Logger log = LoggerFactory.getLogger(RequestValidator.class);
    private static final String BEARER_AUTH_PREFIX = "Bearer";
    private ApplicationContext appContext;

    @Override
    public String getName() {
        return "request-validation";
    }

    @Override
    public void handleRequest(RequestEvent call) {
        log.trace("executing request validator ON REQUEST");
        this.appContext = (ApplicationContext)call.context();
        SecretManagerProvider.instance.set(this.getSecret(call));
        this.validateAgainstLifecycle(call);
        this.rejectUnauthorizedCalls(call);
        if (this.appContext.container().configuration().mode() != Mode.offline) {
            this.validateScopeCall();
            this.validatePolicy(call);
        }
    }

    @Override
    public void handleResponse(ResponseEvent e) {
        log.debug("resetting all the Thread local for this call.");
        SecretManagerProvider.instance.reset();
    }

    private void validateAgainstLifecycle(RequestEvent call) {
        switch ((ApplicationState)this.appContext.lifecycle().state()) {
            case stopped: {
                RequestError.application_unavailable_error.fire();
                break;
            }
            case failed: {
                RequestError.application_failed_error.fire();
                break;
            }
        }
    }

    private void validateScopeCall() {
        String context = SecretManagerProvider.instance.get().getContext();
        if (context == null) {
            log.warn("rejecting unscoped call to {}", (Object)this.appContext.name());
            RequestError.invalid_request_error.fire("call is unscoped");
        }
        ContextBean bean = new ContextBean(context);
        ContainerConfiguration conf = this.appContext.container().configuration();
        Set<String> allowedContexts = conf.authorizationProvider().getContexts();
        if (!(allowedContexts.contains(context) || conf.authorizeChildrenContext() && bean.is(ContextBean.Type.VRE) && allowedContexts.contains(bean.enclosingScope().toString()))) {
            log.warn("rejecting call to {} in invalid context {}, allowed context are {}", new Object[]{this.appContext.name(), context, allowedContexts});
            RequestError.invalid_request_error.fire(this.appContext.name() + " cannot be called in scope " + context);
        }
    }

    private void rejectUnauthorizedCalls(RequestEvent call) {
        Secret secret = SecretManagerProvider.instance.get();
        if (secret == null) {
            log.warn("rejecting call to {}, authorization required", (Object)this.appContext.name());
            RequestError.request_not_authorized_error.fire(this.appContext.name() + ": authorization required");
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    private void validatePolicy(RequestEvent call) {
    }

    private Secret getSecret(RequestEvent call) {
        String token = call.request().getParameter("gcube-token") == null ? call.request().getHeader("gcube-token") : call.request().getParameter("gcube-token");
        String authHeader = call.request().getHeader("Authorization");
        log.trace("authorization header is {}", (Object)authHeader);
        log.trace("token header is {}", (Object)token);
        log.info("d4s-user set to {} ", (Object)call.request().getHeader("d4s-user"));
        String accessToken = null;
        if (authHeader != null && !authHeader.isEmpty() && authHeader.startsWith(BEARER_AUTH_PREFIX)) {
            accessToken = authHeader.substring(BEARER_AUTH_PREFIX.length()).trim();
        }
        AccessTokenSecret secret = null;
        if (accessToken != null) {
            secret = new AccessTokenSecret(accessToken);
            SimpleCredentials credentials = (SimpleCredentials)this.appContext.container().configuration().authorizationProvider().getCredentials();
            KeycloakClient client = KeycloakClientFactory.newInstance();
            try {
                if (!client.isAccessTokenVerified(secret.getContext(), credentials.getClientID(), credentials.getSecret(), accessToken)) {
                    RequestError.invalid_request_error.fire("access token verification error");
                }
            }
            catch (KeycloakClientException e) {
                RequestError.internal_server_error.fire("error contacting keycloak client", e);
            }
        } else if (token != null) {
            secret = new GCubeSecret(token);
        }
        return secret;
    }
}

