/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handlers.application.lifecycle;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.events.Observes;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.common.resources.gcore.Resources;
import org.gcube.smartgears.context.Property;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.handlers.application.ApplicationLifecycleEvent;
import org.gcube.smartgears.handlers.application.ApplicationLifecycleHandler;
import org.gcube.smartgears.handlers.application.lifecycle.ProfileBuilder;
import org.gcube.smartgears.handlers.application.lifecycle.ProfilePublisher;
import org.gcube.smartgears.lifecycle.application.ApplicationLifecycle;
import org.gcube.smartgears.lifecycle.application.ApplicationState;
import org.gcube.smartgears.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="profile-management")
public class ProfileManager
extends ApplicationLifecycleHandler {
    Logger log = LoggerFactory.getLogger(ProfileManager.class);
    private ApplicationContext context;
    private ProfileBuilder builder;
    private ProfilePublisher publisher;

    @Override
    public void onStart(ApplicationLifecycleEvent.Start e) {
        this.context = (ApplicationContext)e.context();
        this.builder = new ProfileBuilder(this.context);
        this.publisher = new ProfilePublisher(this.context);
        GCoreEndpoint profile = this.loadOrCreateProfile();
        this.share(profile);
        this.registerObservers();
    }

    private void registerObservers() {
        this.context.events().subscribe(new Object(){

            @Observes(value={"activation", "stop", "failure"})
            void onChanged(ApplicationLifecycle lc) {
                GCoreEndpoint profile = ProfileManager.this.context.profile(GCoreEndpoint.class);
                profile.profile().deploymentData().status(((ApplicationState)lc.state()).remoteForm());
                ProfileManager.this.context.events().fire((Object)profile, new String[]{"changed"});
            }

            @Observes(value={"published"}, kind=Observes.Kind.resilient)
            void storeAfterPublish(GCoreEndpoint profile) {
                ProfileManager.this.store(profile);
            }

            @Observes(value={"published"})
            void shareAfterPublish(GCoreEndpoint profile) {
                ProfileManager.this.share(profile);
            }

            @Observes(value={"changed"}, kind=Observes.Kind.critical)
            void publishAfterChange(GCoreEndpoint profile) {
                ProfileManager.this.publish(profile);
            }
        });
    }

    private void share(GCoreEndpoint profile) {
        this.log.trace("sharing profile for {}", (Object)this.context.name());
        this.context.properties().add(new Property("endpoint-profile", profile));
    }

    private void publish(GCoreEndpoint profile) {
        boolean firstPublication = this.context.profile(GCoreEndpoint.class).scopes().isEmpty();
        try {
            if (firstPublication) {
                Collection containerScopes = this.context.container().profile(HostingNode.class).scopes().asCollection();
                this.publisher.addTo(containerScopes);
            } else {
                this.publisher.update();
            }
        }
        catch (Exception e) {
            this.log.error("cannot publish {} (see details)", (Object)this.context.name(), (Object)e);
            this.store(profile);
        }
    }

    private GCoreEndpoint loadOrCreateProfile() {
        File file = this.context.configuration().persistence().file("endpoint.xml");
        return file.exists() ? this.load(file) : this.create();
    }

    private GCoreEndpoint create() {
        this.log.info("creating profile for {}", (Object)this.context.name());
        try {
            GCoreEndpoint profile = new GCoreEndpoint();
            this.builder.fill(profile);
            return profile;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("cannot create profile for " + this.context.name(), e);
        }
    }

    private GCoreEndpoint load(File file) {
        GCoreEndpoint gCoreEndpoint;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            this.log.info("loading profile for {} @ {}", (Object)this.context.name(), (Object)file.getAbsolutePath());
            GCoreEndpoint profile = (GCoreEndpoint)Resources.unmarshal(GCoreEndpoint.class, (InputStream)in);
            this.builder.fill(profile);
            gCoreEndpoint = profile;
        }
        catch (Throwable e) {
            try {
                throw new RuntimeException("cannot load profile for " + this.context.name() + " @ " + file.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                Utils.closeSafely(in);
                throw throwable;
            }
        }
        Utils.closeSafely(in);
        return gCoreEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(GCoreEndpoint profile) {
        File file = this.context.persistence().file("endpoint.xml");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            this.log.trace("storing profile for {} @ {}", (Object)this.context.name(), (Object)file.getAbsolutePath());
            Resources.marshal((Object)profile, (OutputStream)out);
        }
        catch (Exception e) {
            try {
                this.log.error("cannot store profile for {} @ {}", (Object)new Object[]{this.context.name(), file.getAbsolutePath()}, (Object)e);
            }
            catch (Throwable throwable) {
                Utils.closeSafely(out);
                throw throwable;
            }
            Utils.closeSafely(out);
        }
        Utils.closeSafely(out);
    }

    @Override
    public String toString() {
        return "profile-management";
    }
}

