/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.persistence;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.gcube.documentstore.persistence.PersistenceBackend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PersistenceBackendConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceBackendConfiguration.class);
    protected Map<String, String> properties = new HashMap<String, String>();

    protected static PersistenceBackendConfiguration getUnconfiguredInstance() {
        ServiceLoader<PersistenceBackendConfiguration> serviceLoader = ServiceLoader.load(PersistenceBackendConfiguration.class);
        Iterator<PersistenceBackendConfiguration> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            PersistenceBackendConfiguration foundConfiguration = iterator.next();
            Class<?> configClass = foundConfiguration.getClass();
            String foundConfigurationClassName = configClass.getSimpleName();
            logger.trace("{} will be used.", (Object)foundConfigurationClassName);
            return foundConfiguration;
        }
        return null;
    }

    public static PersistenceBackendConfiguration getInstance(Class<? extends PersistenceBackend> clz) {
        ServiceLoader<PersistenceBackendConfiguration> serviceLoader = ServiceLoader.load(PersistenceBackendConfiguration.class);
        for (PersistenceBackendConfiguration foundConfiguration : serviceLoader) {
            try {
                Class<?> configClass = foundConfiguration.getClass();
                String foundConfigurationClassName = configClass.getSimpleName();
                logger.trace("Testing {}", (Object)foundConfigurationClassName);
                Class[] configArgTypes = new Class[]{Class.class};
                Constructor<?> configurationConstructor = configClass.getDeclaredConstructor(configArgTypes);
                Object[] configArguments = new Object[]{clz};
                PersistenceBackendConfiguration configuration = (PersistenceBackendConfiguration)configurationConstructor.newInstance(configArguments);
                logger.trace("{} will be used.", (Object)foundConfigurationClassName);
                return configuration;
            }
            catch (InvocationTargetException e) {
                logger.error(String.format("InvocationTargetException -%s not initialized correctly. It will not be used. Trying the next one if any.", foundConfiguration.getClass().getSimpleName()), e.getCause());
            }
            catch (Exception e) {
                logger.error(String.format("%s not initialized correctly. It will not be used. Trying the next one if any.", foundConfiguration.getClass().getSimpleName()), (Throwable)e);
            }
        }
        return null;
    }

    protected PersistenceBackendConfiguration() {
    }

    public PersistenceBackendConfiguration(Class<? extends PersistenceBackend> clz) {
        this();
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getProperty(String key) throws Exception {
        return this.properties.get(key);
    }

    public String toString() {
        return this.properties.toString();
    }
}

