/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handlers.application.lifecycle;

import java.net.URI;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletRegistration;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.authorization.client.proxy.AuthorizationProxy;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.events.Observes;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.impl.embedded.HeaderImpl;
import org.gcube.informationsystem.impl.embedded.RelationPropertyImpl;
import org.gcube.informationsystem.impl.embedded.ValueSchemaImpl;
import org.gcube.informationsystem.impl.entity.facet.AccessPointFacetImpl;
import org.gcube.informationsystem.impl.entity.facet.ServiceStateFacetImpl;
import org.gcube.informationsystem.impl.entity.facet.SoftwareFacetImpl;
import org.gcube.informationsystem.impl.entity.resource.EServiceImpl;
import org.gcube.informationsystem.impl.relation.IsIdentifiedByImpl;
import org.gcube.informationsystem.impl.relation.isrelatedto.HostsImpl;
import org.gcube.informationsystem.model.embedded.Header;
import org.gcube.informationsystem.model.embedded.RelationProperty;
import org.gcube.informationsystem.model.embedded.ValueSchema;
import org.gcube.informationsystem.model.entity.Facet;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.model.entity.facet.ServiceStateFacet;
import org.gcube.informationsystem.model.entity.resource.EService;
import org.gcube.informationsystem.model.entity.resource.HostingNode;
import org.gcube.informationsystem.model.relation.ConsistsOf;
import org.gcube.informationsystem.model.relation.IsRelatedTo;
import org.gcube.informationsystem.model.relation.isrelatedto.Hosts;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.client.proxy.ResourceRegistryClient;
import org.gcube.informationsystem.resourceregistry.client.proxy.ResourceRegistryClientFactory;
import org.gcube.informationsystem.resourceregistry.publisher.proxy.ResourceRegistryPublisher;
import org.gcube.informationsystem.resourceregistry.publisher.proxy.ResourceRegistryPublisherFactory;
import org.gcube.smartgears.configuration.application.ApplicationConfiguration;
import org.gcube.smartgears.context.Property;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.handlers.application.ApplicationLifecycleEvent;
import org.gcube.smartgears.handlers.application.ApplicationLifecycleHandler;
import org.gcube.smartgears.handlers.application.lifecycle.ProfileBuilder;
import org.gcube.smartgears.lifecycle.application.ApplicationLifecycle;
import org.gcube.smartgears.lifecycle.application.ApplicationState;
import org.gcube.smartgears.lifecycle.container.ContainerLifecycle;
import org.gcube.smartgears.provider.ProviderFactory;
import org.gcube.smartgears.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="resource-management")
public class EServiceManager
extends ApplicationLifecycleHandler {
    private static final Logger logger = LoggerFactory.getLogger(EServiceManager.class);
    private ApplicationContext applicationContext;
    private AuthorizationProxy authorizationProxy = ProviderFactory.provider().authorizationProxy();
    private ScheduledFuture<?> periodicUpdates;

    private void setContextFromToken(String token) {
        if (token == null || token.compareTo("") == 0) {
            SecurityTokenProvider.instance.reset();
            ScopeProvider.instance.reset();
        } else {
            SecurityTokenProvider.instance.set(token);
            String scope = this.getCurrentContextName(token);
            ScopeProvider.instance.set(scope);
        }
    }

    @Override
    public void onStart(ApplicationLifecycleEvent.Start e) {
        this.applicationContext = (ApplicationContext)e.context();
        EService eService = this.instantiateEService();
        eService = this.publishEservice(eService);
        this.registerObservers();
        this.schedulePeriodicUpdates();
    }

    private void share(EService eService) {
        logger.trace("sharing EService for {}", (Object)this.applicationContext.name());
        this.applicationContext.properties().add(new Property("EService", eService));
    }

    private void registerObservers() {
        this.applicationContext.events().subscribe(new Object(){

            @Observes(value={"activation", "stop", "failure"})
            void onChanged(ApplicationLifecycle lc) {
                String state = ((ApplicationState)lc.state()).remoteForm().toLowerCase();
                logger.debug("Moving app {} to {}", (Object)EServiceManager.this.applicationContext.name(), (Object)state);
                EService eService = EServiceManager.this.applicationContext.profile(EService.class);
                EServiceManager.this.createOrUpdateServiceStateFacet(eService, state);
            }

            @Observes(value={"addToContext"})
            void addTo(String token) {
                EService eService = EServiceManager.this.applicationContext.profile(EService.class);
                EServiceManager.this.addToContext(eService, token);
            }

            @Observes(value={"removeFromContext"})
            void removeFrom(String token) {
                EService eService = EServiceManager.this.applicationContext.profile(EService.class);
                EServiceManager.this.removeFromContext(eService, token);
            }
        });
    }

    private void schedulePeriodicUpdates() {
        this.applicationContext.events().subscribe(new Object(){

            @Observes(value={"activation"}, kind=Observes.Kind.resilient)
            synchronized void restartPeriodicUpdates(final ApplicationLifecycle lc) {
                if (EServiceManager.this.periodicUpdates != null) {
                    return;
                }
                if (lc.state() == ApplicationState.active) {
                    logger.info("scheduling periodic updates of application {} EService", (Object)EServiceManager.this.applicationContext.name());
                } else {
                    logger.info("resuming periodic updates of application {} EService", (Object)EServiceManager.this.applicationContext.name());
                }
                Runnable updateTask = new Runnable(){

                    @Override
                    public void run() {
                        EService eService = EServiceManager.this.applicationContext.profile(EService.class);
                        try {
                            String state = ((ApplicationState)lc.state()).remoteForm().toLowerCase();
                            EServiceManager.this.createOrUpdateServiceStateFacet(eService, state);
                        }
                        catch (Exception e) {
                            logger.error("cannot complete periodic update of EService", (Throwable)e);
                        }
                    }
                };
                EServiceManager.this.periodicUpdates = Utils.scheduledServicePool.scheduleAtFixedRate(updateTask, 20L, 20L, TimeUnit.MINUTES);
            }

            @Observes(value={"stop", "failure"}, kind=Observes.Kind.resilient)
            synchronized void cancelPeriodicUpdates(ContainerLifecycle ignore) {
                if (EServiceManager.this.periodicUpdates != null) {
                    logger.trace("stopping periodic updates of application {} EService", (Object)EServiceManager.this.applicationContext.name());
                    try {
                        EServiceManager.this.periodicUpdates.cancel(true);
                        EServiceManager.this.periodicUpdates = null;
                    }
                    catch (Exception e) {
                        logger.warn("could not stop periodic updates of application {} EService", (Object)EServiceManager.this.applicationContext.name(), (Object)e);
                    }
                }
            }
        });
    }

    private void createHostsRelation(EService eService, ResourceRegistryPublisher resourceRegistryPublisher) {
        HostingNode hostingNode = this.applicationContext.container().profile(HostingNode.class);
        if (hostingNode != null) {
            HostsImpl hosts = null;
            List isRelatedToList = hostingNode.getIsRelatedTo();
            for (IsRelatedTo isRelatedTo : isRelatedToList) {
                if (!(isRelatedTo instanceof Hosts) || ((Resource)isRelatedTo.getTarget()).getHeader().getUUID().compareTo(eService.getHeader().getUUID()) != 0) continue;
                hosts = (Hosts)isRelatedTo;
                break;
            }
            if (hosts == null) {
                RelationPropertyImpl relationProperty = new RelationPropertyImpl();
                relationProperty.setReferentialIntegrity(RelationProperty.ReferentialIntegrity.onDeleteCascade);
                hosts = new HostsImpl(hostingNode, eService, (RelationProperty)relationProperty);
                Hosts gotHosts = (Hosts)resourceRegistryPublisher.createIsRelatedTo(Hosts.class, (IsRelatedTo)hosts);
                hosts.setHeader(gotHosts.getHeader());
                hostingNode.attachResource((IsRelatedTo)hosts);
            }
        }
    }

    private EService createEServiceAndHosts(ResourceRegistryPublisher resourceRegistryPublisher, EService eService) throws ResourceNotFoundException, ResourceRegistryException {
        try {
            eService = (EService)resourceRegistryPublisher.createResource(EService.class, (Resource)eService);
        }
        catch (Exception e) {
            ResourceRegistryClient registryClient = ResourceRegistryClientFactory.create();
            eService = (EService)registryClient.getResource(EService.class, eService.getHeader().getUUID());
        }
        try {
            this.createHostsRelation(eService, resourceRegistryPublisher);
        }
        catch (Exception ex) {
            logger.error("Unable to Create {} relation from {} to {} ({} : {})", new Object[]{"Hosts", "HostingNode", "EService", this.applicationContext.name(), eService.getHeader().getUUID(), ex});
        }
        return eService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EService publishEservice(EService eService) {
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        String previousToken = SecurityTokenProvider.instance.get();
        try {
            Thread.currentThread().setContextClassLoader(EServiceManager.class.getClassLoader());
            boolean create = true;
            Set<String> startTokens = this.applicationContext.configuration().startTokens();
            for (String token : startTokens) {
                this.setContextFromToken(token);
                try {
                    ResourceRegistryPublisher resourceRegistryPublisher = ResourceRegistryPublisherFactory.create();
                    if (create) {
                        eService = this.createEServiceAndHosts(resourceRegistryPublisher, eService);
                        create = false;
                    } else {
                        boolean added = resourceRegistryPublisher.addResourceToContext((Resource)eService);
                        if (added) {
                            logger.info("{} successfully added to current context ({})", (Object)eService, (Object)this.getCurrentContextName(token));
                            this.share(eService);
                        } else {
                            logger.error("Unable to add {} to current context ({})", (Object)eService, (Object)this.getCurrentContextName(token));
                        }
                    }
                    this.share(eService);
                }
                catch (Exception e) {
                    logger.error("Unable to add {} to current context ({})", new Object[]{eService, this.getCurrentContextName(token), e});
                }
            }
        }
        catch (Exception e) {
            Utils.rethrowUnchecked(e);
        }
        finally {
            this.setContextFromToken(previousToken);
            Thread.currentThread().setContextClassLoader(contextCL);
        }
        return eService;
    }

    private String getCurrentContextName(String token) {
        try {
            return this.authorizationProxy.get(token).getContext();
        }
        catch (Exception e) {
            logger.error("Error retrieving token {}, it should never happen", (Object)token);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromContext(EService eService, String token) {
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        String previousToken = SecurityTokenProvider.instance.get();
        try {
            Thread.currentThread().setContextClassLoader(EServiceManager.class.getClassLoader());
            this.setContextFromToken(token);
            boolean removed = false;
            if (removed) {
                logger.info("{} successfully removed from current context ({})", (Object)eService, (Object)this.getCurrentContextName(token));
                this.share(eService);
            } else {
                logger.error("Unable to remove {} from current context ({})", (Object)eService, (Object)this.getCurrentContextName(token));
            }
            this.share(eService);
        }
        catch (Exception e) {
            logger.error("Unable to remove {} from current context ({})", new Object[]{eService, this.getCurrentContextName(token), e});
            Utils.rethrowUnchecked(e);
        }
        finally {
            this.setContextFromToken(previousToken);
            Thread.currentThread().setContextClassLoader(contextCL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToContext(EService eService, String token) {
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        String previousToken = SecurityTokenProvider.instance.get();
        try {
            Thread.currentThread().setContextClassLoader(EServiceManager.class.getClassLoader());
            this.setContextFromToken(token);
            ResourceRegistryPublisher resourceRegistryPublisher = ResourceRegistryPublisherFactory.create();
            boolean added = resourceRegistryPublisher.addResourceToContext((Resource)eService);
            if (added) {
                logger.info("{} successfully added to current context ({})", (Object)eService, (Object)this.getCurrentContextName(token));
                this.share(eService);
            } else {
                logger.error("Unable to add {} to current context ({})", (Object)eService, (Object)this.getCurrentContextName(token));
            }
            this.share(eService);
        }
        catch (Exception e) {
            logger.error("Unable to add {} to current context ({})", new Object[]{eService, this.getCurrentContextName(token), e});
            Utils.rethrowUnchecked(e);
        }
        finally {
            this.setContextFromToken(previousToken);
            Thread.currentThread().setContextClassLoader(contextCL);
        }
    }

    private ConsistsOf<EService, ServiceStateFacet> createConsistsOf(ConsistsOf<EService, ServiceStateFacet> consistsOf, ResourceRegistryPublisher resourceRegistryPublisher) {
        return resourceRegistryPublisher.createConsistsOf(ConsistsOf.class, consistsOf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOrUpdateServiceStateFacet(EService eService, String state) {
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        String previousToken = SecurityTokenProvider.instance.get();
        try {
            if (previousToken == null) {
                this.setContextFromToken((String)this.applicationContext.configuration().startTokens().toArray()[0]);
            }
            Thread.currentThread().setContextClassLoader(EServiceManager.class.getClassLoader());
            ServiceStateFacet serviceStateFacet = null;
            List consistsOfList = eService.getConsistsOf();
            for (ConsistsOf c : consistsOfList) {
                if (!(c.getTarget() instanceof ServiceStateFacet)) continue;
                serviceStateFacet = (ServiceStateFacet)c.getTarget();
                break;
            }
            ResourceRegistryPublisher resourceRegistryPublisher = ResourceRegistryPublisherFactory.create();
            try {
                serviceStateFacet.setValue(state);
                serviceStateFacet = (ServiceStateFacet)resourceRegistryPublisher.updateFacet(ServiceStateFacet.class, serviceStateFacet);
            }
            catch (Exception e) {
                try {
                    ConsistsOf<EService, ServiceStateFacet> consistsOf = new ConsistsOf<EService, ServiceStateFacet>((Resource)eService, (Facet)serviceStateFacet, null);
                    consistsOf = this.createConsistsOf(consistsOf, resourceRegistryPublisher);
                    eService.addFacet(consistsOf);
                }
                catch (Exception ex) {
                    eService = this.createEServiceAndHosts(resourceRegistryPublisher, eService);
                }
            }
            this.share(eService);
        }
        catch (Exception e) {
            Utils.rethrowUnchecked(e);
        }
        finally {
            this.setContextFromToken(previousToken);
            Thread.currentThread().setContextClassLoader(contextCL);
        }
    }

    private EService instantiateEService() {
        logger.info("Creating EService for {}", (Object)this.applicationContext.name());
        ApplicationConfiguration applicationConfiguration = this.applicationContext.configuration();
        UUID uuid = UUID.fromString(this.applicationContext.id());
        EServiceImpl eService = new EServiceImpl();
        HeaderImpl header = new HeaderImpl(uuid);
        eService.setHeader((Header)header);
        SoftwareFacetImpl softwareFacet = new SoftwareFacetImpl();
        softwareFacet.setDescription(applicationConfiguration.description());
        softwareFacet.setGroup(applicationConfiguration.serviceClass());
        softwareFacet.setName(applicationConfiguration.name());
        softwareFacet.setVersion(applicationConfiguration.version());
        IsIdentifiedByImpl isIdentifiedBy = new IsIdentifiedByImpl((Resource)eService, (Facet)softwareFacet, null);
        eService.addFacet((ConsistsOf)isIdentifiedBy);
        String baseAddress = ProfileBuilder.getBaseAddress(this.applicationContext);
        for (ServletRegistration servlet : this.applicationContext.application().getServletRegistrations().values()) {
            if (ProfileBuilder.servletExcludes.contains(servlet.getName())) continue;
            for (String mapping : servlet.getMappings()) {
                String address = ProfileBuilder.getAddressFromBaseAddress(baseAddress, mapping);
                AccessPointFacetImpl accessPointFacet = new AccessPointFacetImpl();
                accessPointFacet.setEntryName(servlet.getName());
                accessPointFacet.setEndpoint(URI.create(address));
                ValueSchemaImpl valueSchema = new ValueSchemaImpl();
                valueSchema.setValue("gcube-token");
                accessPointFacet.setAuthorization((ValueSchema)valueSchema);
                eService.addFacet((Facet)accessPointFacet);
            }
        }
        ServiceStateFacetImpl serviceStateFacet = new ServiceStateFacetImpl();
        String state = ((ApplicationState)this.applicationContext.lifecycle().state()).remoteForm().toLowerCase();
        serviceStateFacet.setValue(state.toLowerCase());
        eService.addFacet((Facet)serviceStateFacet);
        return eService;
    }

    @Override
    public String toString() {
        return "resource-management";
    }
}

