/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transcoder;

import com.couchbase.client.core.lang.Tuple;
import com.couchbase.client.core.lang.Tuple2;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.kv.MutationToken;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import com.couchbase.client.java.document.StringDocument;
import com.couchbase.client.java.error.TranscodingException;
import com.couchbase.client.java.transcoder.AbstractTranscoder;
import com.couchbase.client.java.transcoder.TranscoderUtils;

public class StringTranscoder
extends AbstractTranscoder<StringDocument, String> {
    @Override
    protected StringDocument doDecode(String id, ByteBuf content, long cas, int expiry, int flags, ResponseStatus status) throws Exception {
        if (!TranscoderUtils.hasStringFlags(flags)) {
            throw new TranscodingException("Flags (0x" + Integer.toHexString(flags) + ") indicate non-String document for " + "id " + id + ", could not decode.");
        }
        return this.newDocument(id, expiry, content.toString(CharsetUtil.UTF_8), cas);
    }

    @Override
    protected Tuple2<ByteBuf, Integer> doEncode(StringDocument document) throws Exception {
        return Tuple.create((Object)TranscoderUtils.encodeStringAsUtf8((String)document.content()), (Object)TranscoderUtils.STRING_COMMON_FLAGS);
    }

    @Override
    public StringDocument newDocument(String id, int expiry, String content, long cas) {
        return StringDocument.create(id, expiry, content, cas);
    }

    @Override
    public StringDocument newDocument(String id, int expiry, String content, long cas, MutationToken mutationToken) {
        return StringDocument.create(id, expiry, content, cas, mutationToken);
    }

    @Override
    public Class<StringDocument> documentType() {
        return StringDocument.class;
    }
}

