/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.search;

import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.endpoint.AbstractEndpoint;
import com.couchbase.client.core.endpoint.AbstractGenericHandler;
import com.couchbase.client.core.endpoint.ResponseStatusConverter;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.AbstractCouchbaseResponse;
import com.couchbase.client.core.message.CouchbaseResponse;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.search.GetSearchIndexRequest;
import com.couchbase.client.core.message.search.GetSearchIndexResponse;
import com.couchbase.client.core.message.search.RemoveSearchIndexRequest;
import com.couchbase.client.core.message.search.RemoveSearchIndexResponse;
import com.couchbase.client.core.message.search.SearchQueryRequest;
import com.couchbase.client.core.message.search.SearchQueryResponse;
import com.couchbase.client.core.message.search.SearchRequest;
import com.couchbase.client.core.message.search.UpsertSearchIndexRequest;
import com.couchbase.client.core.message.search.UpsertSearchIndexResponse;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.deps.com.lmax.disruptor.EventSink;
import com.couchbase.client.deps.com.lmax.disruptor.RingBuffer;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.deps.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpContent;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpObject;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpRequest;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpResponse;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpVersion;
import com.couchbase.client.deps.io.netty.handler.codec.http.LastHttpContent;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import java.util.Queue;

public class SearchHandler
extends AbstractGenericHandler<HttpObject, HttpRequest, SearchRequest> {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(SearchHandler.class);
    private HttpResponse responseHeader;
    private ByteBuf responseContent;

    public SearchHandler(AbstractEndpoint endpoint, EventSink<ResponseEvent> responseBuffer, boolean isTransient, boolean pipeline) {
        super(endpoint, responseBuffer, isTransient, pipeline);
    }

    SearchHandler(AbstractEndpoint endpoint, RingBuffer<ResponseEvent> responseBuffer, Queue<SearchRequest> queue, boolean isTransient, boolean pipeline) {
        super(endpoint, responseBuffer, queue, isTransient, pipeline);
    }

    @Override
    protected HttpRequest encodeRequest(ChannelHandlerContext ctx, SearchRequest msg) throws Exception {
        HttpMethod httpMethod = HttpMethod.GET;
        if (msg instanceof UpsertSearchIndexRequest) {
            httpMethod = HttpMethod.PUT;
        } else if (msg instanceof RemoveSearchIndexRequest) {
            httpMethod = HttpMethod.DELETE;
        } else if (msg instanceof SearchQueryRequest) {
            httpMethod = HttpMethod.POST;
        }
        ByteBuf content = msg instanceof UpsertSearchIndexRequest ? Unpooled.copiedBuffer(((UpsertSearchIndexRequest)msg).payload(), CharsetUtil.UTF_8) : (msg instanceof SearchQueryRequest ? Unpooled.copiedBuffer(((SearchQueryRequest)msg).payload(), CharsetUtil.UTF_8) : Unpooled.EMPTY_BUFFER);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, httpMethod, msg.path(), content);
        request.headers().set("User-Agent", (Object)this.env().userAgent());
        if (msg instanceof UpsertSearchIndexRequest || msg instanceof SearchQueryRequest) {
            request.headers().set("Accept", (Object)"*/*");
            request.headers().set("Content-Type", (Object)"application/json");
        }
        request.headers().set("Content-Length", (Object)content.readableBytes());
        request.headers().set("Host", (Object)this.remoteHttpHost(ctx));
        SearchHandler.addHttpBasicAuth(ctx, request, msg.bucket(), msg.password());
        return request;
    }

    @Override
    protected CouchbaseResponse decodeResponse(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        SearchRequest request = (SearchRequest)this.currentRequest();
        AbstractCouchbaseResponse response = null;
        if (msg instanceof HttpResponse) {
            this.responseHeader = (HttpResponse)msg;
            if (this.responseContent != null) {
                this.responseContent.clear();
            } else {
                this.responseContent = ctx.alloc().buffer();
            }
        }
        if (msg instanceof HttpContent) {
            this.responseContent.writeBytes(((HttpContent)msg).content());
        }
        if (msg instanceof LastHttpContent) {
            String body;
            ResponseStatus status = ResponseStatusConverter.fromHttp(this.responseHeader.getStatus().code());
            String string = body = this.responseContent.readableBytes() > 0 ? this.responseContent.toString(CHARSET) : this.responseHeader.getStatus().reasonPhrase();
            if (request instanceof UpsertSearchIndexRequest) {
                response = new UpsertSearchIndexResponse(body, status);
            } else if (request instanceof GetSearchIndexRequest) {
                response = new GetSearchIndexResponse(body, status);
            } else if (request instanceof RemoveSearchIndexRequest) {
                response = new RemoveSearchIndexResponse(body, status);
            } else if (request instanceof SearchQueryRequest) {
                response = new SearchQueryResponse(body, status);
            }
            this.finishedDecoding();
        }
        return response;
    }

    @Override
    protected ServiceType serviceType() {
        return ServiceType.SEARCH;
    }
}

