/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.view;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.view.ViewQueryResponse;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import com.couchbase.client.java.AsyncBucket;
import com.couchbase.client.java.CouchbaseAsyncBucket;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.error.TranscodingException;
import com.couchbase.client.java.error.ViewDoesNotExistException;
import com.couchbase.client.java.transcoder.JsonTranscoder;
import com.couchbase.client.java.view.AsyncSpatialViewResult;
import com.couchbase.client.java.view.AsyncSpatialViewRow;
import com.couchbase.client.java.view.AsyncViewResult;
import com.couchbase.client.java.view.AsyncViewRow;
import com.couchbase.client.java.view.DefaultAsyncSpatialViewResult;
import com.couchbase.client.java.view.DefaultAsyncSpatialViewRow;
import com.couchbase.client.java.view.DefaultAsyncViewResult;
import com.couchbase.client.java.view.DefaultAsyncViewRow;
import com.couchbase.client.java.view.SpatialViewQuery;
import com.couchbase.client.java.view.ViewQuery;
import rx.Observable;
import rx.functions.Func1;

@InterfaceStability.Committed
@InterfaceAudience.Private
public class ViewQueryResponseMapper {
    private static final JsonTranscoder TRANSCODER = CouchbaseAsyncBucket.JSON_OBJECT_TRANSCODER;

    public static Observable<AsyncViewResult> mapToViewResult(AsyncBucket bucket, ViewQuery query, ViewQueryResponse response) {
        return response.info().singleOrDefault(null).map((Func1)new ByteBufToJsonObject()).map((Func1)new BuildViewResult(bucket, query, response));
    }

    public static Observable<AsyncSpatialViewResult> mapToSpatialViewResult(AsyncBucket bucket, SpatialViewQuery query, ViewQueryResponse response) {
        return response.info().singleOrDefault(null).map((Func1)new ByteBufToJsonObject()).map((Func1)new BuildSpatialViewResult(bucket, query, response));
    }

    static class BuildViewResult
    implements Func1<JsonObject, AsyncViewResult> {
        private final AsyncBucket bucket;
        private final ViewQuery query;
        private final ViewQueryResponse response;

        BuildViewResult(AsyncBucket bucket, ViewQuery query, ViewQueryResponse response) {
            this.bucket = bucket;
            this.query = query;
            this.response = response;
        }

        public AsyncViewResult call(JsonObject jsonInfo) {
            JsonObject debug = null;
            int totalRows = 0;
            boolean success = this.response.status().isSuccess();
            if (success) {
                debug = jsonInfo.getObject("debug_info");
                Integer trows = jsonInfo.getInt("total_rows");
                if (trows != null) {
                    totalRows = trows;
                }
            } else if (this.response.status() == ResponseStatus.NOT_EXISTS) {
                throw new ViewDoesNotExistException("View " + this.query.getDesign() + "/" + this.query.getView() + " does not exist.");
            }
            Observable rows = this.response.rows().map((Func1)new ByteBufToJsonObject()).flatMap((Func1)new Func1<JsonObject, Observable<AsyncViewRow>>(){

                public Observable<AsyncViewRow> call(final JsonObject row) {
                    final String id = row.getString("id");
                    if (BuildViewResult.this.query.isIncludeDocs()) {
                        return BuildViewResult.this.bucket.get(id, BuildViewResult.this.query.includeDocsTarget()).map(new Func1<Document<?>, AsyncViewRow>(){

                            public AsyncViewRow call(Document<?> document) {
                                return new DefaultAsyncViewRow(BuildViewResult.this.bucket, id, row.get("key"), row.get("value"), document);
                            }
                        });
                    }
                    return Observable.just((Object)new DefaultAsyncViewRow(BuildViewResult.this.bucket, id, row.get("key"), row.get("value"), null));
                }
            });
            Observable error = this.response.error().map((Func1)new Func1<String, JsonObject>(){

                public JsonObject call(String input) {
                    try {
                        return TRANSCODER.stringToJsonObject(input);
                    }
                    catch (Exception e) {
                        throw new TranscodingException("Could not decode View JSON: " + input, e);
                    }
                }
            });
            return new DefaultAsyncViewResult((Observable<AsyncViewRow>)rows, totalRows, success, (Observable<JsonObject>)error, debug);
        }
    }

    static class BuildSpatialViewResult
    implements Func1<JsonObject, AsyncSpatialViewResult> {
        private final AsyncBucket bucket;
        private final SpatialViewQuery query;
        private final ViewQueryResponse response;

        BuildSpatialViewResult(AsyncBucket bucket, SpatialViewQuery query, ViewQueryResponse response) {
            this.bucket = bucket;
            this.query = query;
            this.response = response;
        }

        public AsyncSpatialViewResult call(JsonObject jsonInfo) {
            JsonObject debug = null;
            boolean success = this.response.status().isSuccess();
            if (success) {
                debug = jsonInfo.getObject("debug_info");
            } else if (this.response.status() == ResponseStatus.NOT_EXISTS) {
                throw new ViewDoesNotExistException("View " + this.query.getDesign() + "/" + this.query.getView() + " does not exist.");
            }
            Observable rows = this.response.rows().map((Func1)new ByteBufToJsonObject()).flatMap((Func1)new Func1<JsonObject, Observable<AsyncSpatialViewRow>>(){

                public Observable<AsyncSpatialViewRow> call(final JsonObject row) {
                    String id = row.getString("id");
                    if (BuildSpatialViewResult.this.query.isIncludeDocs()) {
                        return BuildSpatialViewResult.this.bucket.get(id, BuildSpatialViewResult.this.query.includeDocsTarget()).map(new Func1<Document<?>, AsyncSpatialViewRow>(){

                            public AsyncSpatialViewRow call(Document<?> document) {
                                return new DefaultAsyncSpatialViewRow(BuildSpatialViewResult.this.bucket, row.getString("id"), row.getArray("key"), row.get("value"), row.getObject("geometry"), document);
                            }
                        });
                    }
                    return Observable.just((Object)new DefaultAsyncSpatialViewRow(BuildSpatialViewResult.this.bucket, row.getString("id"), row.getArray("key"), row.get("value"), row.getObject("geometry"), null));
                }
            });
            Observable error = this.response.error().map((Func1)new Func1<String, JsonObject>(){

                public JsonObject call(String input) {
                    try {
                        return TRANSCODER.stringToJsonObject(input);
                    }
                    catch (Exception e) {
                        throw new TranscodingException("Could not decode View JSON: " + input, e);
                    }
                }
            });
            return new DefaultAsyncSpatialViewResult((Observable<AsyncSpatialViewRow>)rows, success, (Observable<JsonObject>)error, debug);
        }
    }

    static class ByteBufToJsonObject
    implements Func1<ByteBuf, JsonObject> {
        ByteBufToJsonObject() {
        }

        public JsonObject call(ByteBuf input) {
            if (input == null || input.readableBytes() == 0) {
                return JsonObject.empty();
            }
            try {
                JsonObject jsonObject = TRANSCODER.byteBufToJsonObject(input);
                return jsonObject;
            }
            catch (Exception e) {
                throw new TranscodingException("Could not decode View JSON: " + input.toString(CharsetUtil.UTF_8), e);
            }
            finally {
                if (input.refCnt() > 0) {
                    input.release();
                }
            }
        }
    }
}

