/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handlers.application.request;

import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.usagerecords.ServiceUsageRecord;
import org.gcube.accounting.persistence.AccountingPersistence;
import org.gcube.accounting.persistence.AccountingPersistenceFactory;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.CalledMethodProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.documentstore.records.Record;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.handlers.application.RequestEvent;
import org.gcube.smartgears.handlers.application.RequestHandler;
import org.gcube.smartgears.handlers.application.ResponseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="request-accounting")
public class RequestAccounting
extends RequestHandler {
    private static Logger log = LoggerFactory.getLogger(RequestAccounting.class);
    private static ThreadLocal<Long> startCallThreadLocal = new ThreadLocal();

    @Override
    public String getName() {
        return "request-accounting";
    }

    @Override
    public void handleRequest(RequestEvent e) {
        ApplicationContext context = (ApplicationContext)e.context();
        String calledMethod = e.request().getHeader("gcube-method");
        if (calledMethod == null && (calledMethod = e.request().getRequestURI().substring(e.request().getContextPath().length())).isEmpty()) {
            calledMethod = "/";
        }
        CalledMethodProvider.instance.set(calledMethod);
        String caller = AuthorizationProvider.instance.get() != null ? AuthorizationProvider.instance.get().getClient().getId() : "UNKNOWN";
        startCallThreadLocal.set(System.currentTimeMillis());
        log.info("REQUEST START ON {}:{}({}) CALLED FROM {}@{} IN SCOPE {} ", new Object[]{context.configuration().name(), context.configuration().serviceClass(), CalledMethodProvider.instance.get(), caller, e.request().getRemoteHost(), ScopeProvider.instance.get()});
    }

    @Override
    public void handleResponse(ResponseEvent e) {
        ApplicationContext context = (ApplicationContext)e.context();
        boolean resetScope = false;
        if (ScopeProvider.instance.get() == null && SecurityTokenProvider.instance.get() == null) {
            String infrastructure = ((ApplicationContext)e.context()).container().configuration().infrastructure();
            ScopeProvider.instance.set("/" + infrastructure);
            resetScope = true;
        }
        String caller = AuthorizationProvider.instance.get() != null ? AuthorizationProvider.instance.get().getClient().getId() : "UNKNOWN";
        String callerQualifier = AuthorizationProvider.instance.get() != null ? AuthorizationProvider.instance.get().getTokenQualifier() : "UNKNOWN";
        String callerIp = e.request().getHeader("x-forwarded-for");
        if (callerIp == null) {
            callerIp = e.request().getRemoteHost();
        }
        this.generateAccounting(caller, callerQualifier, callerIp == null ? "UNKNOWN" : callerIp, context);
        log.info("REQUEST SERVED ON {}:{}({}) CALLED FROM {}@{} IN SCOPE {} FINISHED IN {} millis", new Object[]{context.configuration().name(), context.configuration().serviceClass(), CalledMethodProvider.instance.get(), caller, callerIp, ScopeProvider.instance.get(), System.currentTimeMillis() - startCallThreadLocal.get()});
        startCallThreadLocal.remove();
        CalledMethodProvider.instance.reset();
        if (resetScope) {
            ScopeProvider.instance.reset();
        }
    }

    void generateAccounting(String caller, String callerQualifier, String remoteHost, ApplicationContext context) {
        AccountingPersistenceFactory.setFallbackLocation((String)context.container().persistence().location());
        AccountingPersistence persistence = AccountingPersistenceFactory.getPersistence();
        ServiceUsageRecord serviceUsageRecord = new ServiceUsageRecord();
        try {
            serviceUsageRecord.setConsumerId(caller);
            serviceUsageRecord.setCallerQualifier(callerQualifier);
            serviceUsageRecord.setScope(ScopeProvider.instance.get());
            serviceUsageRecord.setServiceClass(context.configuration().serviceClass());
            serviceUsageRecord.setServiceName(context.configuration().name());
            serviceUsageRecord.setHost(context.container().configuration().hostname() + ":" + context.container().configuration().port());
            serviceUsageRecord.setCalledMethod(CalledMethodProvider.instance.get());
            serviceUsageRecord.setCallerHost(remoteHost);
            serviceUsageRecord.setOperationResult(UsageRecord.OperationResult.SUCCESS);
            serviceUsageRecord.setDuration(Long.valueOf(System.currentTimeMillis() - startCallThreadLocal.get()));
            persistence.account((Record)serviceUsageRecord);
        }
        catch (Exception ex) {
            log.warn("invalid record passed to accounting ", (Throwable)ex);
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

