/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.records.implementation;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.records.AggregatedRecord;
import org.gcube.documentstore.records.CustomMapDeserializer;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.implementation.AggregatedField;
import org.gcube.documentstore.records.implementation.ComputedField;
import org.gcube.documentstore.records.implementation.FieldAction;
import org.gcube.documentstore.records.implementation.FieldDecorator;
import org.gcube.documentstore.records.implementation.RequiredField;
import org.gcube.documentstore.records.implementation.validations.annotations.NotEmpty;
import org.gcube.documentstore.records.implementation.validations.annotations.ValidLong;
import org.gcube.documentstore.records.implementation.validations.validators.ValidLongValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRecord
implements Record {
    private static final long serialVersionUID = -2060728578456796388L;
    private static Logger logger = LoggerFactory.getLogger(AbstractRecord.class);
    @NotEmpty
    protected static final String ID = "id";
    @ValidLong
    protected static final String CREATION_TIME = "creationTime";
    @JsonDeserialize(using=CustomMapDeserializer.class)
    @JsonIgnoreProperties(ignoreUnknown=true)
    protected Map<String, Serializable> resourceProperties;
    protected Map<String, List<FieldAction>> validation;
    protected Map<String, List<FieldAction>> computation;
    @JsonIgnore
    protected Set<String> requiredFields;
    @JsonIgnore
    protected Set<String> computedFields;
    @JsonIgnore
    protected Set<String> aggregatedFields;

    protected static Set<Field> getAllFields(Class<?> type) {
        HashSet<Field> fields = new HashSet<Field>();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            fields.addAll(Arrays.asList(c.getDeclaredFields()));
            fields.addAll(Arrays.asList(c.getFields()));
        }
        return fields;
    }

    protected void initializeValidation() {
        Set<Field> fields = AbstractRecord.getAllFields(this.getClass());
        for (Field field : fields) {
            String keyString;
            boolean defaultAccessibility = field.isAccessible();
            field.setAccessible(true);
            try {
                keyString = (String)field.get(null);
            }
            catch (Exception e) {
                continue;
            }
            if (field.getAnnotations().length > 0) {
                List<FieldAction> fieldComputations;
                List<FieldAction> fieldValidators = this.validation.get(keyString);
                if (fieldValidators == null) {
                    fieldValidators = new ArrayList<FieldAction>();
                    this.validation.put(keyString, fieldValidators);
                }
                if ((fieldComputations = this.computation.get(keyString)) == null) {
                    fieldComputations = new ArrayList<FieldAction>();
                    this.computation.put(keyString, fieldComputations);
                }
                for (Annotation annotation : field.getAnnotations()) {
                    FieldAction computeAction;
                    Class<? extends FieldAction> managedClass;
                    Class<? extends Annotation> annotationType = annotation.annotationType();
                    if (annotationType.isAnnotationPresent(FieldDecorator.class)) {
                        FieldAction validator;
                        managedClass = annotationType.getAnnotation(FieldDecorator.class).action();
                        try {
                            validator = managedClass.newInstance();
                        }
                        catch (IllegalAccessException | InstantiationException e) {
                            logger.error("{} {}", new Object[]{keyString, annotation, e});
                            continue;
                        }
                        fieldValidators.add(validator);
                    }
                    if (annotationType.isAssignableFrom(RequiredField.class)) {
                        this.requiredFields.add(keyString);
                    }
                    if (annotationType.isAssignableFrom(AggregatedField.class)) {
                        this.aggregatedFields.add(keyString);
                    }
                    if (!annotationType.isAssignableFrom(ComputedField.class)) continue;
                    this.computedFields.add(keyString);
                    managedClass = ((ComputedField)annotation).action();
                    try {
                        computeAction = managedClass.newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        logger.error("{} {}", new Object[]{keyString, annotation, e});
                        continue;
                    }
                    fieldComputations.add(computeAction);
                }
            }
            field.setAccessible(defaultAccessibility);
        }
    }

    @Override
    public SortedSet<String> getQuerableKeys() throws Exception {
        TreeSet<String> properties = new TreeSet<String>(this.getRequiredFields());
        properties.removeAll(this.getAggregatedFields());
        properties.removeAll(this.getComputedFields());
        properties.remove(ID);
        properties.remove(CREATION_TIME);
        return properties;
    }

    protected void cleanExtraFields() {
        Set<String> neededFields = this.requiredFields;
        neededFields.addAll(this.aggregatedFields);
        HashSet<String> keysToRemove = new HashSet<String>();
        Set<String> propertyKeys = this.resourceProperties.keySet();
        for (String propertyName : propertyKeys) {
            if (neededFields.contains(propertyName)) continue;
            keysToRemove.add(propertyName);
        }
        for (String keyToRemove : keysToRemove) {
            this.resourceProperties.remove(keyToRemove);
        }
    }

    protected void init() {
        this.validation = new HashMap<String, List<FieldAction>>();
        this.computation = new HashMap<String, List<FieldAction>>();
        this.requiredFields = new HashSet<String>();
        this.aggregatedFields = new HashSet<String>();
        this.computedFields = new HashSet<String>();
        this.resourceProperties = new HashMap<String, Serializable>();
        this.initializeValidation();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public AbstractRecord() {
        this.init();
        this.resourceProperties.put(ID, (Serializable)((Object)UUID.randomUUID().toString()));
        Calendar calendar = Calendar.getInstance();
        this.resourceProperties.put(CREATION_TIME, Long.valueOf(calendar.getTimeInMillis()));
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public AbstractRecord(Map<String, ? extends Serializable> properties) throws InvalidValueException {
        this.init();
        this.setResourceProperties(properties);
        if (this instanceof AggregatedRecord) {
            this.resourceProperties.put("aggregated", Boolean.valueOf(true));
            this.cleanExtraFields();
        }
    }

    @Override
    public Set<String> getRequiredFields() {
        return new HashSet<String>(this.requiredFields);
    }

    @Override
    public Set<String> getComputedFields() {
        return new HashSet<String>(this.computedFields);
    }

    public Set<String> getAggregatedFields() {
        return new HashSet<String>(this.aggregatedFields);
    }

    @Override
    public String getId() {
        return (String)((Object)this.resourceProperties.get(ID));
    }

    @Override
    public void setId(String id) throws InvalidValueException {
        this.setResourceProperty(ID, (Serializable)((Object)id));
    }

    public static Calendar timestampToCalendar(long millis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millis);
        return calendar;
    }

    @Override
    public Calendar getCreationTime() {
        Long millis = null;
        try {
            millis = (Long)new ValidLongValidator().validate(CREATION_TIME, this.resourceProperties.get(CREATION_TIME), null);
            return AbstractRecord.timestampToCalendar(millis);
        }
        catch (InvalidValueException e) {
            return null;
        }
    }

    @Override
    public void setCreationTime(Calendar creationTime) throws InvalidValueException {
        this.setResourceProperty(CREATION_TIME, Long.valueOf(creationTime.getTimeInMillis()));
    }

    @Override
    public Map<String, Serializable> getResourceProperties() {
        return new HashMap<String, Serializable>(this.resourceProperties);
    }

    @Override
    @JsonAnySetter
    public void setResourceProperties(Map<String, ? extends Serializable> properties) throws InvalidValueException {
        Map<String, ? extends Serializable> validated = this.validateProperties(properties);
        this.resourceProperties = new HashMap<String, Serializable>(validated);
    }

    @Override
    @JsonAnyGetter
    public Serializable getResourceProperty(String key) {
        return this.resourceProperties.get(key);
    }

    @Override
    public void removeResourceProperty(String key) {
        this.resourceProperties.remove(key);
    }

    @Override
    @JsonAnySetter
    public void setResourceProperty(String key, Serializable value) throws InvalidValueException {
        Serializable checkedValue = this.validateField(key, value);
        if (checkedValue == null) {
            this.resourceProperties.remove(key);
        } else {
            this.resourceProperties.put(key, checkedValue);
        }
    }

    protected void setEndTime(Calendar endTime) throws InvalidValueException {
        this.setResourceProperty("endTime", Long.valueOf(endTime.getTimeInMillis()));
    }

    protected int getOperationCount() {
        return (Integer)this.resourceProperties.get("operationCount");
    }

    protected void setOperationCount(int operationCount) throws InvalidValueException {
        this.setResourceProperty("operationCount", Integer.valueOf(operationCount));
    }

    protected long getStartTimeInMillis() {
        return (Long)this.resourceProperties.get("startTime");
    }

    protected Calendar getStartTimeAsCalendar() {
        long millis = this.getStartTimeInMillis();
        return AbstractRecord.timestampToCalendar(millis);
    }

    protected void setStartTime(Calendar startTime) throws InvalidValueException {
        this.setResourceProperty("startTime", Long.valueOf(startTime.getTimeInMillis()));
    }

    protected long getEndTimeInMillis() {
        return (Long)this.resourceProperties.get("endTime");
    }

    protected void setAggregate(Boolean aggregate) throws InvalidValueException {
        this.setResourceProperty("aggregated", aggregate);
    }

    protected Boolean getAggregate() {
        return (Boolean)this.resourceProperties.get("aggregated");
    }

    protected Calendar getEndTimeAsCalendar() {
        long millis = this.getEndTimeInMillis();
        return AbstractRecord.timestampToCalendar(millis);
    }

    protected Serializable validateField(String key, Serializable value) throws InvalidValueException {
        if (key == null) {
            throw new InvalidValueException("The key of property to set cannot be null");
        }
        Serializable checkedValue = value;
        List<FieldAction> fieldValidators = this.validation.get(key);
        if (fieldValidators != null) {
            for (FieldAction fieldValidator : fieldValidators) {
                if (this.aggregatedFields.contains(key)) {
                    // empty if block
                }
                if (this.computedFields.contains(key)) {
                    logger.debug("{} is a computed field. To be calculated all the required fields to calcutalate it MUST be set. In any case the provided value will be ignored.", (Object)key);
                }
                try {
                    if ((checkedValue = fieldValidator.validate(key, checkedValue, this)) != null) continue;
                    return null;
                }
                catch (InvalidValueException e) {
                    logger.error(String.format("The provided value %s is NOT valid for field with key %s.", checkedValue.toString(), key));
                    throw e;
                }
            }
        }
        return checkedValue;
    }

    protected void computeField(String key) throws InvalidValueException {
        if (key == null) {
            throw new InvalidValueException("The key of property to set cannot be null");
        }
        Serializable computedValue = null;
        List<FieldAction> fieldComputations = this.computation.get(key);
        if (fieldComputations != null) {
            for (FieldAction fieldValidator : fieldComputations) {
                try {
                    computedValue = fieldValidator.validate(key, null, this);
                    this.resourceProperties.put(key, computedValue);
                }
                catch (InvalidValueException e) {
                    logger.error(String.format("Unable to calculate the field with key %s", key));
                    throw e;
                }
            }
        }
    }

    protected Map<String, ? extends Serializable> validateProperties(Map<String, ? extends Serializable> properties) throws InvalidValueException {
        HashMap<String, Serializable> validated = new HashMap<String, Serializable>();
        for (String key : properties.keySet()) {
            Serializable value;
            Serializable checkedValue = this.validateField(key, value = properties.get(key));
            if (checkedValue == null) {
                validated.remove(key);
                continue;
            }
            validated.put(key, checkedValue);
        }
        return validated;
    }

    @Override
    public void validate() throws InvalidValueException {
        for (String string : this.computedFields) {
            this.computeField(string);
        }
        this.validateProperties(this.resourceProperties);
        HashSet<String> notPresentProperties = new HashSet<String>();
        for (String key : this.requiredFields) {
            if (this.resourceProperties.containsKey(key)) continue;
            notPresentProperties.add(key);
        }
        if (!notPresentProperties.isEmpty()) {
            String string = notPresentProperties.size() == 1 ? "y" : "ies";
            logger.debug("ID doc:{}", (Object)this.getId());
            throw new InvalidValueException(String.format("The Record does not contain the following required propert%s %s", string, ((Object)notPresentProperties).toString()));
        }
    }

    public String toString() {
        return this.resourceProperties.toString();
    }

    @Override
    public int compareTo(Record record) {
        Set<Map.Entry<String, Serializable>> thisSet = this.resourceProperties.entrySet();
        Set<Map.Entry<String, Serializable>> recordSet = record.getResourceProperties().entrySet();
        if (thisSet.size() != recordSet.size()) {
            return thisSet.size() - recordSet.size();
        }
        if (recordSet.containsAll(thisSet)) {
            return 0;
        }
        return 1;
    }
}

