/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.client;

import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.base.reference.IdentifiableElement;
import org.gcube.informationsystem.context.reference.entities.Context;
import org.gcube.informationsystem.model.reference.entities.Entity;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.model.reference.relations.IsRelatedTo;
import org.gcube.informationsystem.model.reference.relations.Relation;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.query.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.rest.httputils.HTTPUtility;
import org.gcube.informationsystem.resourceregistry.api.utils.Utility;
import org.gcube.informationsystem.resourceregistry.client.Direction;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClient;
import org.gcube.informationsystem.types.TypeMapper;
import org.gcube.informationsystem.types.reference.Type;
import org.gcube.informationsystem.utils.ElementMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryClientImpl
implements ResourceRegistryClient {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistryClientImpl.class);
    protected final String address;

    public ResourceRegistryClientImpl(String address) {
        this.address = address;
    }

    @Override
    public Context getCurrentContext() throws ContextNotFoundException, ResourceRegistryException {
        try {
            logger.info("Going to get current {} ", (Object)"Context");
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("access");
            gxHTTPStringRequest.path("contexts");
            gxHTTPStringRequest.path("CURRENT_CONTEXT");
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            Context context = (Context)HTTPUtility.getResponse(Context.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got Context is {}", (Object)ElementMapper.marshal((Element)context));
            return context;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Context getContext(UUID uuid) throws ContextNotFoundException, ResourceRegistryException {
        try {
            logger.info("Going to get {} with UUID {}", (Object)"Context", (Object)uuid.toString());
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("access");
            gxHTTPStringRequest.path("contexts");
            gxHTTPStringRequest.path(uuid.toString());
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            Context context = (Context)HTTPUtility.getResponse(Context.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got Context is {}", (Object)ElementMapper.marshal((Element)context));
            return context;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Context> getAllContext() throws ContextNotFoundException, ResourceRegistryException {
        try {
            logger.info("Going to read all {}s", (Object)"Context");
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("access");
            gxHTTPStringRequest.path("contexts");
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String ret = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got Contexts are {}", (Object)ret);
            return ElementMapper.unmarshalList(Context.class, (String)ret);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <E extends Element> List<Type> getSchema(Class<E> clazz, Boolean polymorphic) throws SchemaNotFoundException, ResourceRegistryException {
        String typeName = Utility.getTypeName(clazz);
        try {
            logger.info("Going to get {} schema", (Object)typeName);
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("access");
            gxHTTPStringRequest.path("types");
            gxHTTPStringRequest.path(typeName);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("polymorphic", polymorphic.toString());
            gxHTTPStringRequest.queryParams(parameters);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String json = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got schema for {} is {}", (Object)typeName, (Object)json);
            return TypeMapper.deserializeTypeDefinitions((String)json);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <IE extends IdentifiableElement> boolean exists(Class<IE> clazz, UUID uuid) throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        String type = Utility.getTypeName(clazz);
        return this.exists(type, uuid);
    }

    @Override
    public boolean exists(String type, UUID uuid) throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        try {
            logger.info("Going to check if {} with UUID {} exists", (Object)type, (Object)uuid);
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("access");
            gxHTTPStringRequest.path("instances");
            gxHTTPStringRequest.path(type);
            gxHTTPStringRequest.path(uuid.toString());
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.head();
            HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("{} with UUID {} exists", (Object)type, (Object)uuid);
            return true;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <IE extends IdentifiableElement> IE getInstance(Class<IE> clazz, UUID uuid) throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        String type = Utility.getTypeName(clazz);
        String ret = this.getInstance(type, uuid);
        try {
            return (IE)((IdentifiableElement)ElementMapper.unmarshal(clazz, (String)ret));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getInstance(String type, UUID uuid) throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        try {
            logger.info("Going to get {} with UUID {}", (Object)type, (Object)uuid);
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("access");
            gxHTTPStringRequest.path("instances");
            gxHTTPStringRequest.path(type);
            gxHTTPStringRequest.path(uuid.toString());
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String ret = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got {} with UUID {} is {}", new Object[]{type, uuid, ret});
            return ret;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <IE extends IdentifiableElement, R extends Resource> List<R> getInstances(Class<IE> clazz, Boolean polymorphic) throws ResourceRegistryException {
        String type = Utility.getTypeName(clazz);
        String ret = this.getInstances(type, polymorphic);
        try {
            return ElementMapper.unmarshalList(Resource.class, (String)ret);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getInstances(String type, Boolean polymorphic) throws ResourceRegistryException {
        try {
            logger.info("Going to get all instances of {} ", (Object)type);
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("access");
            gxHTTPStringRequest.path("instances");
            gxHTTPStringRequest.path(type);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("polymorphic", polymorphic.toString());
            gxHTTPStringRequest.queryParams(parameters);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String ret = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got instances of {} are {}", (Object)type, (Object)ret);
            return ret;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String query(String query, int limit, String fetchPlan) throws InvalidQueryException, ResourceRegistryException {
        return this.query(query, limit, fetchPlan, false);
    }

    @Override
    public String query(String query, int limit, String fetchPlan, boolean raw) throws InvalidQueryException, ResourceRegistryException {
        try {
            logger.info("Going to query. {}", (Object)query);
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("access");
            gxHTTPStringRequest.path("query");
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("q", query);
            if (limit <= 0) {
                limit = -1;
            }
            parameters.put("limit", Integer.toString(limit));
            parameters.put("raw", Boolean.toString(raw));
            if (fetchPlan != null && fetchPlan.compareTo("") != 0) {
                parameters.put("fetchPlan", fetchPlan);
            }
            gxHTTPStringRequest.queryParams(parameters);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String ret = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Query result is {}", (Object)ret);
            return ret;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getRelated(String entityType, String relationType, String referenceEntityType, UUID referenceEntity, Direction direction, Boolean polymorphic, Map<String, String> map) throws ResourceRegistryException {
        try {
            GXHTTPStringRequest gxHTTPStringRequest = GXHTTPStringRequest.newRequest((String)this.address);
            gxHTTPStringRequest.from(ResourceRegistryClient.class.getSimpleName());
            gxHTTPStringRequest.header("Accept", "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("access");
            gxHTTPStringRequest.path("query");
            gxHTTPStringRequest.path(entityType);
            gxHTTPStringRequest.path(relationType);
            gxHTTPStringRequest.path(referenceEntityType);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("direction", direction.name());
            parameters.put("polymorphic", polymorphic.toString());
            if (referenceEntity == null) {
                if (map != null && map.size() > 0) {
                    logger.info("Going to get {} linked by a {} Relation to a {} having {}", new Object[]{entityType, relationType, referenceEntityType, map});
                    parameters.putAll(map);
                } else {
                    logger.info("Going to get {} linked by a {} Relation to a {}", new Object[]{entityType, relationType, referenceEntityType});
                }
            } else {
                logger.info("Going to get {} linked by {} to {} with UUID {}", new Object[]{entityType, relationType, referenceEntityType, referenceEntity});
                parameters.put("reference", referenceEntity.toString());
            }
            gxHTTPStringRequest.queryParams(parameters);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String json = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            if (referenceEntity == null) {
                logger.info("{} linked by {} to/from {} having {} are {}", new Object[]{entityType, relationType, referenceEntityType, map, json});
            } else {
                logger.info("{} linked by {} to/from {} with UUID {} are", new Object[]{entityType, relationType, referenceEntityType, referenceEntity, json});
            }
            return json;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <R extends Resource, C extends ConsistsOf<?, ?>, F extends Facet> List<R> getResourcesFromReferenceFacet(Class<R> resourceClass, Class<C> consistsOfClass, Class<F> facetClass, F referenceFacet, boolean polymorphic) throws ResourceRegistryException {
        UUID referenceFacetUUID = referenceFacet.getHeader().getUUID();
        return this.getResourcesFromReferenceFacet(resourceClass, consistsOfClass, facetClass, referenceFacetUUID, polymorphic);
    }

    @Override
    public <R extends Resource, C extends ConsistsOf<?, ?>, F extends Facet> List<R> getResourcesFromReferenceFacet(Class<R> resourceClass, Class<C> consistsOfClass, Class<F> facetClass, UUID referenceFacetUUID, boolean polymorphic) throws ResourceRegistryException {
        String resourceType = Utility.getTypeName(resourceClass);
        String consistsOfType = Utility.getTypeName(consistsOfClass);
        String facetType = Utility.getTypeName(facetClass);
        String ret = this.getResourcesFromReferenceFacet(resourceType, consistsOfType, facetType, referenceFacetUUID, polymorphic);
        try {
            return ElementMapper.unmarshalList(Resource.class, (String)ret);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getResourcesFromReferenceFacet(String resourceType, String consistsOfType, String facetType, UUID facetUUID, boolean polymorphic) throws ResourceRegistryException {
        return this.getRelated(resourceType, consistsOfType, facetType, facetUUID, Direction.out, polymorphic);
    }

    @Override
    public <R extends Resource, C extends ConsistsOf<?, ?>, F extends Facet> List<R> getFilteredResources(Class<R> resourceClass, Class<C> consistsOfClass, Class<F> facetClass, boolean polymorphic, Map<String, String> map) throws ResourceRegistryException {
        String resourceType = Utility.getTypeName(resourceClass);
        String consistsOfType = Utility.getTypeName(consistsOfClass);
        String facetType = Utility.getTypeName(facetClass);
        String ret = this.getFilteredResources(resourceType, consistsOfType, facetType, polymorphic, map);
        try {
            return ElementMapper.unmarshalList(Resource.class, (String)ret);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getFilteredResources(String resourceType, String consistsOfType, String facetType, boolean polymorphic, Map<String, String> map) throws ResourceRegistryException {
        return this.getRelated(resourceType, consistsOfType, facetType, Direction.out, polymorphic, map);
    }

    @Override
    public <R extends Resource, I extends IsRelatedTo<?, ?>, RR extends Resource> List<R> getRelatedResourcesFromReferenceResource(Class<R> resourceClass, Class<I> isRelatedToClass, Class<RR> referenceResourceClass, RR referenceResource, Direction direction, boolean polymorphic) throws ResourceRegistryException {
        UUID referenceResourceUUID = referenceResource.getHeader().getUUID();
        return this.getRelatedResourcesFromReferenceResource(resourceClass, isRelatedToClass, referenceResourceClass, referenceResourceUUID, direction, polymorphic);
    }

    @Override
    public <R extends Resource, I extends IsRelatedTo<?, ?>, RR extends Resource> List<R> getRelatedResourcesFromReferenceResource(Class<R> resourceClass, Class<I> isRelatedToClass, Class<RR> referenceResourceClass, UUID referenceResourceUUID, Direction direction, boolean polymorphic) throws ResourceRegistryException {
        String resourceType = Utility.getTypeName(resourceClass);
        String isRelatedToType = Utility.getTypeName(isRelatedToClass);
        String referenceResourceType = Utility.getTypeName(referenceResourceClass);
        String ret = this.getRelatedResourcesFromReferenceResource(resourceType, isRelatedToType, referenceResourceType, referenceResourceUUID, direction, polymorphic);
        try {
            return ElementMapper.unmarshalList(Resource.class, (String)ret);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getRelatedResourcesFromReferenceResource(String resourceType, String isRelatedToType, String referenceResourceType, UUID referenceResourceUUID, Direction direction, boolean polymorphic) throws ResourceRegistryException {
        return this.getRelated(resourceType, isRelatedToType, referenceResourceType, referenceResourceUUID, direction, polymorphic);
    }

    @Override
    public <R extends Resource, I extends IsRelatedTo<?, ?>, RR extends Resource> List<R> getRelatedResources(Class<R> resourceClass, Class<I> isRelatedToClass, Class<RR> referenceResourceClass, Direction direction, boolean polymorphic) throws ResourceRegistryException {
        String resourceType = Utility.getTypeName(resourceClass);
        String isRelatedToType = Utility.getTypeName(isRelatedToClass);
        String referenceResourceType = Utility.getTypeName(referenceResourceClass);
        String ret = this.getRelatedResources(resourceType, isRelatedToType, referenceResourceType, direction, polymorphic);
        try {
            return ElementMapper.unmarshalList(Resource.class, (String)ret);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getRelatedResources(String resourceType, String isRelatedToType, String referenceResourceType, Direction direction, boolean polymorphic) throws ResourceRegistryException {
        return this.getRelated(resourceType, isRelatedToType, referenceResourceType, direction, polymorphic, null);
    }

    protected <E extends Entity, R extends Relation<?, ?>, RE extends Entity> List<E> getRelated(Class<E> entityClass, Class<R> relationClass, Class<RE> referenceEntityClass, Direction direction, boolean polymorphic, Map<String, String> map) throws ResourceRegistryException {
        String entityType = Utility.getTypeName(entityClass);
        String relationType = Utility.getTypeName(relationClass);
        String referenceEntityType = Utility.getTypeName(referenceEntityClass);
        String ret = this.getRelated(entityType, relationType, referenceEntityType, direction, polymorphic, map);
        try {
            return ElementMapper.unmarshalList(Resource.class, (String)ret);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getRelated(String entityType, String relationType, String referenceEntityType, Direction direction, boolean polymorphic, Map<String, String> map) throws ResourceRegistryException {
        return this.getRelated(entityType, relationType, referenceEntityType, null, direction, polymorphic, map);
    }

    protected <E extends Entity, R extends Relation<?, ?>, RE extends Entity> List<E> getRelated(Class<E> entityClass, Class<R> relationClass, Class<RE> referenceEntityClass, RE referenceEntity, Direction direction, boolean polymorphic) throws ResourceRegistryException {
        UUID referenceEntityUUID = referenceEntity.getHeader().getUUID();
        return this.getRelated(entityClass, relationClass, referenceEntityClass, referenceEntityUUID, direction, polymorphic);
    }

    protected <E extends Entity, R extends Relation<?, ?>, RE extends Entity> List<E> getRelated(Class<E> entityClass, Class<R> relationClass, Class<RE> referenceEntityClass, UUID referenceEntityUUID, Direction direction, boolean polymorphic) throws ResourceRegistryException {
        String entityType = Utility.getTypeName(entityClass);
        String relationType = Utility.getTypeName(relationClass);
        String referenceEntityType = Utility.getTypeName(referenceEntityClass);
        String ret = this.getRelated(entityType, relationType, referenceEntityType, referenceEntityUUID, direction, polymorphic);
        try {
            return ElementMapper.unmarshalList(Resource.class, (String)ret);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getRelated(String entityType, String relationType, String referenceEntityType, UUID referenceEntity, Direction direction, boolean polymorphic) throws ResourceRegistryException {
        return this.getRelated(entityType, relationType, referenceEntityType, referenceEntity, direction, polymorphic, null);
    }
}

