/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.persistence;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorUtils {
    private static final Logger logger = LoggerFactory.getLogger(ExecutorUtils.class);
    public static final ScheduledExecutorService PERSISTENCE_BACKEND_REDISCOVERY_POOL = Executors.newScheduledThreadPool(20, new ThreadFactory(){
        private int counter = 0;
        private static final String prefix = "PersistenceBackendRediscoveryThread";

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "PersistenceBackendRediscoveryThread-" + this.counter++);
        }
    });
    public static final ScheduledExecutorService CONFIGURATION_REDISCOVERY_POOL = Executors.newScheduledThreadPool(20, new ThreadFactory(){
        private int counter = 0;
        private static final String prefix = "ConfigurationRediscoveryThread";

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "ConfigurationRediscoveryThread-" + this.counter++);
        }
    });
    public static final ScheduledExecutorService FUTURE_FLUSH_POOL = Executors.newScheduledThreadPool(20, new ThreadFactory(){
        private int counter = 0;
        private static final String prefix = "FlushThread";

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "FlushThread-" + this.counter++);
        }
    });
    public static final ScheduledExecutorService FALLBACK_ELABORATOR_POOL = Executors.newScheduledThreadPool(20, new ThreadFactory(){
        private int counter = 0;
        private static final String prefix = "FallbackElaboratorThread";

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "FallbackElaboratorThread-" + this.counter++);
        }
    });
    public static final ExecutorService ASYNC_AGGREGATION_POOL = Executors.newFixedThreadPool(30, new ThreadFactory(){
        private int counter = 0;
        private static final String prefix = "AsyncAggregationThread";

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "AsyncAggregationThread-" + this.counter++);
        }
    });

    public static void shutDownPool(ExecutorService pool) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                    logger.error("Unable to shutdown the pool {}", (Object)pool);
                }
            }
        }
        catch (InterruptedException e) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static void shutDownAll() {
        ExecutorUtils.shutDownPool(PERSISTENCE_BACKEND_REDISCOVERY_POOL);
        ExecutorUtils.shutDownPool(CONFIGURATION_REDISCOVERY_POOL);
        ExecutorUtils.shutDownPool(FUTURE_FLUSH_POOL);
        ExecutorUtils.shutDownPool(FALLBACK_ELABORATOR_POOL);
        ExecutorUtils.shutDownPool(ASYNC_AGGREGATION_POOL);
    }
}

