/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.types.impl.entities;

import java.io.StringWriter;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.entities.EntityElement;
import org.gcube.informationsystem.context.reference.entities.Context;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.Header;
import org.gcube.informationsystem.types.impl.TypeImpl;
import org.gcube.informationsystem.types.impl.entities.FacetTypeImpl;
import org.gcube.informationsystem.types.impl.entities.ResourceTypeImpl;
import org.gcube.informationsystem.types.reference.entities.EntityType;
import org.gcube.informationsystem.utils.ElementMapper;

@JsonTypeName(value="EntityType")
public class EntityTypeImpl
extends TypeImpl
implements EntityType {
    private static final long serialVersionUID = 2614315845213942880L;
    protected Header header;

    public static EntityType getEntityTypeDefinitionInstance(Class<? extends EntityElement> clz) {
        if (Resource.class.isAssignableFrom(clz)) {
            Class<? extends EntityElement> c = clz;
            return new ResourceTypeImpl((Class<? extends Resource>)c);
        }
        if (Facet.class.isAssignableFrom(clz)) {
            Class<? extends EntityElement> c = clz;
            return new FacetTypeImpl((Class<? extends Facet>)c);
        }
        return new EntityTypeImpl(clz);
    }

    protected EntityTypeImpl() {
    }

    public EntityTypeImpl(Class<? extends EntityElement> clz) {
        super(clz);
        if (EntityType.class.isAssignableFrom(clz)) {
            Class<? extends EntityElement> c = clz;
            this.superClasses = this.retrieveSuperClasses(c, EntityType.class, "EntityElement");
        } else if (Context.class.isAssignableFrom(clz)) {
            Class<? extends EntityElement> c = clz;
            this.superClasses = this.retrieveSuperClasses(c, Context.class, "EntityElement");
        } else if (EntityElement.class.isAssignableFrom(clz)) {
            this.superClasses = this.retrieveSuperClasses(clz, EntityElement.class, null);
        } else {
            throw new RuntimeException("Type Hierachy Error for class " + clz.getSimpleName());
        }
        this.properties = this.retrieveListOfProperties(clz);
    }

    @Override
    public Header getHeader() {
        return this.header;
    }

    @Override
    public void setHeader(Header header) {
        this.header = header;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        try {
            ElementMapper.marshal(this, stringWriter);
            return stringWriter.toString();
        }
        catch (Exception e) {
            try {
                ElementMapper.marshal(this.header, stringWriter);
                return stringWriter.toString();
            }
            catch (Exception e1) {
                return super.toString();
            }
        }
    }

    @Override
    @JsonIgnore
    public AccessType getAccessType() {
        if (this.name.compareTo("Context") == 0) {
            return AccessType.CONTEXT;
        }
        if (this.name.compareTo("EntityElement") == 0) {
            return AccessType.ENTITY_ELEMENT;
        }
        if (this.name.compareTo("EntityType") == 0 || this.name.compareTo("ResourceType") == 0 || this.name.compareTo("FacetType") == 0) {
            return AccessType.ENTITY_TYPE;
        }
        return AccessType.ENTITY;
    }
}

