/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.types;

import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gcube.informationsystem.model.reference.properties.Property;

public class OrientDBType {
    protected static final Map<Class<?>, OType> TYPES_BY_CLASS = new HashMap();

    public static OType getTypeByClass(Class<?> iClass) {
        if (iClass == null) {
            return null;
        }
        OType type = TYPES_BY_CLASS.get(iClass);
        if (type == null && Enum.class.isAssignableFrom(iClass)) {
            type = TYPES_BY_CLASS.get(Enum.class);
        }
        return type;
    }

    static {
        TYPES_BY_CLASS.put(Boolean.TYPE, OType.BOOLEAN);
        TYPES_BY_CLASS.put(Boolean.class, OType.BOOLEAN);
        TYPES_BY_CLASS.put(Integer.TYPE, OType.INTEGER);
        TYPES_BY_CLASS.put(Integer.class, OType.INTEGER);
        TYPES_BY_CLASS.put(BigInteger.class, OType.INTEGER);
        TYPES_BY_CLASS.put(Short.TYPE, OType.SHORT);
        TYPES_BY_CLASS.put(Short.class, OType.SHORT);
        TYPES_BY_CLASS.put(Long.TYPE, OType.LONG);
        TYPES_BY_CLASS.put(Long.class, OType.LONG);
        TYPES_BY_CLASS.put(Float.TYPE, OType.FLOAT);
        TYPES_BY_CLASS.put(Float.class, OType.FLOAT);
        TYPES_BY_CLASS.put(Double.TYPE, OType.DOUBLE);
        TYPES_BY_CLASS.put(Double.class, OType.DOUBLE);
        TYPES_BY_CLASS.put(Date.class, OType.DATETIME);
        TYPES_BY_CLASS.put(Calendar.class, OType.DATETIME);
        TYPES_BY_CLASS.put(String.class, OType.STRING);
        TYPES_BY_CLASS.put(Character.class, OType.STRING);
        TYPES_BY_CLASS.put(Character.TYPE, OType.STRING);
        TYPES_BY_CLASS.put(Property.class, OType.PROPERTY);
        TYPES_BY_CLASS.put(List.class, OType.PROPERTYLIST);
        TYPES_BY_CLASS.put(Set.class, OType.PROPERTYSET);
        TYPES_BY_CLASS.put(Map.class, OType.PROPERTYMAP);
        TYPES_BY_CLASS.put(Byte.TYPE, OType.BYTE);
        TYPES_BY_CLASS.put(Byte.class, OType.BYTE);
        TYPES_BY_CLASS.put(byte[].class, OType.BYNARY);
        TYPES_BY_CLASS.put(Byte[].class, OType.BYNARY);
        TYPES_BY_CLASS.put(Enum.class, OType.STRING);
        TYPES_BY_CLASS.put(URI.class, OType.STRING);
        TYPES_BY_CLASS.put(URL.class, OType.STRING);
        TYPES_BY_CLASS.put(UUID.class, OType.STRING);
    }

    public static enum OType {
        BOOLEAN("Boolean", 0),
        INTEGER("Integer", 1),
        SHORT("Short", 2),
        LONG("Long", 3),
        FLOAT("Float", 4),
        DOUBLE("Double", 5),
        DATETIME("Datetime", 6),
        STRING("String", 7),
        BYNARY("Bynary", 8),
        PROPERTY("Property", 9),
        PROPERTYLIST("Property List", 10),
        PROPERTYSET("Property Set", 11),
        PROPERTYMAP("Property Map", 12),
        BYTE("Byte", 17),
        BINARY("Binary", 8);

        private String stringValue;
        private int intValue;

        private OType(String stringValue, int intValue) {
            this.stringValue = stringValue;
            this.intValue = intValue;
        }

        public String getStringValue() {
            return this.stringValue;
        }

        public int getIntValue() {
            return this.intValue;
        }
    }
}

