/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handlers.application.request;

import java.util.Base64;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.authorization.utils.manager.SecretManager;
import org.gcube.common.authorization.utils.manager.SecretManagerProvider;
import org.gcube.common.authorization.utils.secret.GCubeSecret;
import org.gcube.common.authorization.utils.secret.JWTSecret;
import org.gcube.common.authorization.utils.secret.Secret;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.smartgears.handlers.application.RequestEvent;
import org.gcube.smartgears.handlers.application.RequestHandler;
import org.gcube.smartgears.handlers.application.ResponseEvent;
import org.gcube.smartgears.handlers.application.request.RequestError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="context-retriever")
public class RequestContextRetriever
extends RequestHandler {
    private static Logger log = LoggerFactory.getLogger(RequestContextRetriever.class);
    private static final String BEARER_AUTH_PREFIX = "Bearer";
    private static final String BASIC_AUTH_PREFIX = "Basic";

    @Override
    public String getName() {
        return "context-retriever";
    }

    @Override
    public void handleRequest(RequestEvent call) {
        String token = call.request().getParameter("gcube-token") == null ? call.request().getHeader("gcube-token") : call.request().getParameter("gcube-token");
        String scope = call.request().getParameter("gcube-scope") == null ? call.request().getHeader("gcube-scope") : call.request().getParameter("gcube-scope");
        String authHeader = call.request().getHeader("Authorization");
        log.trace("authorization header is {}", (Object)authHeader);
        log.trace("token header is {}", (Object)token);
        log.trace("scope header is {}", (Object)scope);
        String retrievedUser = null;
        String accessToken = null;
        if (authHeader != null && !authHeader.isEmpty()) {
            if (authHeader.startsWith(BEARER_AUTH_PREFIX)) {
                accessToken = authHeader.substring(BEARER_AUTH_PREFIX.length()).trim();
            } else if (token == null && authHeader.startsWith(BASIC_AUTH_PREFIX)) {
                String basicAuthToken = authHeader.substring(BASIC_AUTH_PREFIX.length()).trim();
                String decodedAuth = new String(Base64.getDecoder().decode(basicAuthToken.getBytes()));
                String[] splitAuth = decodedAuth.split(":");
                token = splitAuth[1];
                retrievedUser = splitAuth[0];
            }
        }
        SecretManager secretManager = new SecretManager();
        SecretManagerProvider.instance.set(secretManager);
        if (accessToken != null) {
            JWTSecret jwtSecret = new JWTSecret(accessToken);
            secretManager.addSecret((Secret)jwtSecret);
        }
        if (token != null) {
            GCubeSecret gCubeSecret = new GCubeSecret(token);
            secretManager.addSecret((Secret)gCubeSecret);
            try {
                if (retrievedUser != null && !gCubeSecret.getClientInfo().getId().equals(retrievedUser)) {
                    RequestError.internal_server_error.fire("user and token owner are not the same");
                }
            }
            catch (Exception e) {
                RequestError.internal_server_error.fire(e.getMessage());
            }
        }
        if (accessToken == null && token == null) {
            if (scope != null) {
                ScopeProvider.instance.set(scope);
            }
        } else {
            try {
                secretManager.set();
            }
            catch (Exception e) {
                RequestError.internal_server_error.fire(e.getMessage());
            }
        }
    }

    @Override
    public void handleResponse(ResponseEvent e) {
        log.debug("resetting all the Thread local for this call.");
        SecretManagerProvider.instance.reset();
    }
}

