/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.gxhttp.reference;

import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.gcube.common.gxhttp.reference.GXConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GXHTTPRequestBuilder {
    protected static final Logger logger = LoggerFactory.getLogger(GXHTTPRequestBuilder.class);
    public GXConnection connection;
    public static final String UUID_REGEX = "^([a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}-[a-fA-F0-9]{8,9}){1}$";

    public GXHTTPRequestBuilder from(String agent) {
        this.connection.setAgent(agent);
        return this;
    }

    public GXHTTPRequestBuilder path(String path) throws UnsupportedEncodingException {
        this.connection.addPath(path);
        return this;
    }

    public GXHTTPRequestBuilder queryParams(Map<String, String> parameters) throws UnsupportedEncodingException {
        if (Objects.nonNull(parameters) && !parameters.isEmpty()) {
            StringBuilder result = new StringBuilder();
            boolean first = true;
            for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    result.append("&");
                }
                result.append(URLEncoder.encode(parameter.getKey(), "UTF-8"));
                result.append("=");
                result.append(URLEncoder.encode(parameter.getValue(), "UTF-8"));
            }
            this.connection.setQueryParameters(result.toString());
        }
        return this;
    }

    public void setSecurityToken(String token) {
        if (!this.connection.isExtCall()) {
            if (Pattern.matches(UUID_REGEX, token)) {
                this.connection.setProperty("gcube-token", token);
            } else {
                this.connection.setProperty("Authorization", "Bearer " + token);
            }
        } else {
            throw new UnsupportedOperationException("Cannot set the security token on an external call");
        }
    }

    public GXHTTPRequestBuilder header(String name, String value) {
        this.connection.setProperty(name, value);
        return this;
    }

    public HttpURLConnection put() throws Exception {
        logger.trace("Sending a PUT request...");
        return this.connection.send(GXConnection.HTTPMETHOD.PUT);
    }

    public HttpURLConnection post() throws Exception {
        logger.trace("Sending a POST request...");
        return this.connection.send(GXConnection.HTTPMETHOD.POST);
    }

    public HttpURLConnection get() throws Exception {
        logger.trace("Sending a GET request...");
        return this.connection.send(GXConnection.HTTPMETHOD.GET);
    }

    public HttpURLConnection delete() throws Exception {
        logger.trace("Sending a DELETE request...");
        return this.connection.send(GXConnection.HTTPMETHOD.DELETE);
    }

    public HttpURLConnection head() throws Exception {
        logger.trace("Sending a HEAD request...");
        return this.connection.send(GXConnection.HTTPMETHOD.HEAD);
    }

    public void clear() {
        this.connection.reset();
    }

    public HttpURLConnection trace() throws Exception {
        logger.trace("Sending a TRACE request...");
        return this.connection.send(GXConnection.HTTPMETHOD.TRACE);
    }

    public HttpURLConnection patch() throws Exception {
        logger.trace("Sending a TRACE request...");
        return this.connection.send(GXConnection.HTTPMETHOD.PATCH);
    }

    public HttpURLConnection options() throws Exception {
        logger.trace("Sending an OPTIONS request...");
        return this.connection.send(GXConnection.HTTPMETHOD.OPTIONS);
    }

    public HttpURLConnection connect() throws Exception {
        logger.trace("Sending a CONNECT request...");
        return this.connection.send(GXConnection.HTTPMETHOD.CONNECT);
    }

    public void isExternalCall(boolean ext) {
        this.connection.setExtCall(ext);
    }
}

