/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.extensions.resource;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.gcube.common.resources.gcore.Resources;
import org.gcube.smartgears.extensions.ApiResource;
import org.gcube.smartgears.extensions.ApiSignature;
import org.gcube.smartgears.extensions.HttpExtension;
import org.gcube.smartgears.handlers.application.request.RequestError;
import org.gcube.smartgears.lifecycle.application.ApplicationState;

public class LifecycleResource
extends ApiResource {
    private static final long serialVersionUID = 1L;
    public static final String mapping = "/lifecyle";
    private static final ApiSignature signature = LifecycleResource.handles("/lifecyle").with(LifecycleResource.method(HttpExtension.Method.GET).produces("application/xml")).with(LifecycleResource.method(HttpExtension.Method.POST).accepts("application/xml"));

    LifecycleResource() {
        super(signature);
    }

    @Override
    public boolean supports(HttpExtension.Method method) {
        return method == HttpExtension.Method.GET || method == HttpExtension.Method.POST;
    }

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            Resources.marshal((Object)new State((ApplicationState)this.context().lifecycle().state()), (Writer)resp.getWriter());
        }
        catch (Exception e) {
            RequestError.invalid_request_error.fire("cannot parse request body", e);
        }
    }

    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        State wrapper = (State)Resources.unmarshal(State.class, (Reader)req.getReader());
        String value = wrapper.value;
        if (value == null || value.isEmpty()) {
            RequestError.invalid_request_error.fire("missing state in request body");
        }
        ApplicationState state = null;
        try {
            state = ApplicationState.valueOf(value);
        }
        catch (Exception e) {
            RequestError.invalid_request_error.fire(value + " is an unkown resource state", e);
        }
        try {
            this.context().lifecycle().moveTo(state);
        }
        catch (Exception e) {
            RequestError.illegal_state_error.fire("invalid state transition for this resource" + value, e);
        }
    }

    @XmlRootElement(name="state")
    public static class State {
        @XmlValue
        public String value;

        State() {
        }

        public State(ApplicationState state) {
            this.value = state.name();
        }
    }
}

