/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handlers.application.lifecycle;

import java.util.Collections;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.events.Observes;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.smartgears.configuration.Mode;
import org.gcube.smartgears.context.Property;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.handlers.OfflineProfilePublisher;
import org.gcube.smartgears.handlers.ProfilePublisher;
import org.gcube.smartgears.handlers.application.ApplicationLifecycleEvent;
import org.gcube.smartgears.handlers.application.ApplicationLifecycleHandler;
import org.gcube.smartgears.handlers.application.lifecycle.ProfileBuilder;
import org.gcube.smartgears.handlers.application.lifecycle.ProfilePublisherImpl;
import org.gcube.smartgears.lifecycle.application.ApplicationLifecycle;
import org.gcube.smartgears.lifecycle.application.ApplicationState;
import org.gcube.smartgears.lifecycle.container.ContainerLifecycle;
import org.gcube.smartgears.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="profile-management")
public class ProfileManager
extends ApplicationLifecycleHandler {
    Logger log = LoggerFactory.getLogger(ProfileManager.class);
    private ApplicationContext context;
    private ProfileBuilder builder;
    private ProfilePublisher publisher;
    private ScheduledFuture<?> periodicUpdates;

    @Override
    public void onStart(ApplicationLifecycleEvent.Start e) {
        this.context = (ApplicationContext)e.context();
        this.builder = new ProfileBuilder(this.context);
        this.activated();
        this.schedulePeriodicUpdates();
    }

    private void activated() {
        GCoreEndpoint profile = this.loadOrCreateProfile();
        this.share(profile);
        this.publisher = this.context.container().configuration().mode() != Mode.offline ? new ProfilePublisherImpl(this.context) : new OfflineProfilePublisher();
        this.registerObservers();
    }

    private void registerObservers() {
        this.context.events().subscribe(new Object(){

            @Observes(value={"activation", "stop", "failure"})
            void onChanged(ApplicationLifecycle lc) {
                GCoreEndpoint profile = ProfileManager.this.context.profile(GCoreEndpoint.class);
                profile.profile().deploymentData().status(((ApplicationState)lc.state()).remoteForm());
                ProfileManager.this.log.debug("moving app {} to {}", (Object)ProfileManager.this.context.name(), (Object)((ApplicationState)lc.state()).remoteForm());
                ProfileManager.this.context.events().fire((Object)profile, new String[]{"changed"});
            }

            @Observes(value={"published"})
            void shareAfterPublish(GCoreEndpoint profile) {
                ProfileManager.this.share(profile);
            }

            @Observes(value={"changed"}, kind=Observes.Kind.safe)
            void publishAfterChange(GCoreEndpoint profile) {
                boolean firstPublication = profile.scopes().isEmpty();
                try {
                    if (firstPublication) {
                        if (ProfileManager.this.context.lifecycle().state() != ApplicationState.failed) {
                            ProfileManager.this.publishFirstTime(profile);
                        }
                    } else {
                        ProfileManager.this.log.debug("update app {} profile", (Object)ProfileManager.this.context.name());
                        ProfileManager.this.publisher.update();
                    }
                }
                catch (Exception e) {
                    ProfileManager.this.log.error("cannot publish " + ProfileManager.this.context.name() + " (see details)", (Throwable)e);
                }
            }

            @Observes(value={"addToContext"})
            void addTo(String token) {
                try {
                    ProfileManager.this.log.trace("publishing application with new token");
                    ProfileManager.this.publisher.addTo(Collections.singleton(token));
                    ProfileManager.this.publisher.update();
                }
                catch (Exception e) {
                    ProfileManager.this.log.error("cannot add token {} (see details)", (Object)token, (Object)e);
                }
            }

            @Observes(value={"removeFromContext"})
            void removeFrom(String token) {
                try {
                    ProfileManager.this.log.trace("unpublishing application with token");
                    ProfileManager.this.publisher.removeFrom(Collections.singleton(token));
                    ProfileManager.this.publisher.update();
                }
                catch (Exception e) {
                    ProfileManager.this.log.error("cannot remove token {} (see details)", (Object)token, (Object)e);
                }
            }
        });
    }

    private void share(GCoreEndpoint profile) {
        this.log.trace("sharing profile for {}", (Object)this.context.name());
        this.context.properties().add(new Property("endpoint-profile", profile));
    }

    private void publishFirstTime(GCoreEndpoint profile) {
        try {
            this.publisher.addToAll();
        }
        catch (Exception e) {
            this.log.warn("publishing failed", (Throwable)e);
        }
    }

    private GCoreEndpoint loadOrCreateProfile() {
        return this.create();
    }

    private GCoreEndpoint create() {
        this.log.info("creating profile for {}", (Object)this.context.name());
        try {
            GCoreEndpoint profile = new GCoreEndpoint();
            profile.setId(this.context.id());
            this.builder.fill(profile);
            return profile;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("cannot create profile for " + this.context.name(), e);
        }
    }

    private void schedulePeriodicUpdates() {
        this.context.events().subscribe(new Object(){

            @Observes(value={"activation"}, kind=Observes.Kind.resilient)
            synchronized void restartPeriodicUpdates(ApplicationLifecycle lc) {
                if (ProfileManager.this.periodicUpdates != null) {
                    return;
                }
                if (lc.state() == ApplicationState.active) {
                    ProfileManager.this.log.info("scheduling periodic updates of application {} profile", (Object)ProfileManager.this.context.name());
                } else {
                    ProfileManager.this.log.info("resuming periodic updates of application {} profile", (Object)ProfileManager.this.context.name());
                }
                Runnable updateTask = new Runnable(){

                    @Override
                    public void run() {
                        GCoreEndpoint profile = ProfileManager.this.context.profile(GCoreEndpoint.class);
                        ProfileManager.this.log.trace("firing change event on application {} profile", (Object)ProfileManager.this.context.name());
                        ProfileManager.this.context.events().fire((Object)profile, new String[]{"changed"});
                    }
                };
                ProfileManager.this.periodicUpdates = Utils.scheduledServicePool.scheduleAtFixedRate(updateTask, 20L, 20L, TimeUnit.MINUTES);
            }

            @Observes(value={"stop", "failure"}, kind=Observes.Kind.resilient)
            synchronized void cancelPeriodicUpdates(ContainerLifecycle ignore) {
                if (ProfileManager.this.periodicUpdates != null) {
                    ProfileManager.this.log.trace("stopping periodic updates of application {} profile", (Object)ProfileManager.this.context.name());
                    try {
                        ProfileManager.this.periodicUpdates.cancel(true);
                        ProfileManager.this.periodicUpdates = null;
                    }
                    catch (Exception e) {
                        ProfileManager.this.log.warn("could not stop periodic updates of application {} profile", (Object)ProfileManager.this.context.name(), (Object)e);
                    }
                }
            }
        });
    }

    @Override
    public String toString() {
        return "profile-management";
    }
}

