/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.persistence;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.documentstore.persistence.HTTPCall;
import org.gcube.documentstore.persistence.PersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackendConfiguration;
import org.gcube.documentstore.records.DSMapper;
import org.gcube.documentstore.records.Record;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceAccountingService
extends PersistenceBackend {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceAccountingService.class);
    public static final String PATH_SERVICE_INSERT_ACCOUNTING = "/record";
    public static final String URL_PROPERTY_KEY = "URL";
    public static final String SERVICE_CLASS = "Accounting";
    public static final String SERVICE_NAME = "AccountingService";
    public static final String SERVICE_ENTRY_NAME = "org.gcube.accounting.service.AccountingResource";
    private static final String USER_AGENT = "document-store-lib-accounting-service";
    private static String FORCED_URL;
    private HTTPCall httpCall;
    private static String classFormat;
    private static String nameFormat;
    private static String statusFormat;
    private static String containsFormat;

    private static SimpleQuery queryForService() {
        logger.trace("going to query GCoreEndpoint of {}", (Object)SERVICE_NAME);
        return ICFactory.queryFor(GCoreEndpoint.class).addCondition(String.format(classFormat, SERVICE_CLASS)).addCondition(String.format(nameFormat, SERVICE_NAME)).addCondition(String.format(statusFormat, new Object[0])).addVariable("$entry", "$resource/Profile/AccessPoint/RunningInstanceInterfaces/Endpoint").addCondition(String.format(containsFormat, SERVICE_ENTRY_NAME)).setResult("$entry/text()");
    }

    protected static void forceURL(String url) {
        FORCED_URL = url;
    }

    protected void prepareConnection(PersistenceBackendConfiguration configuration) throws Exception {
        String url = null;
        if (FORCED_URL != null) {
            url = FORCED_URL;
        } else {
            url = configuration.getProperty(URL_PROPERTY_KEY);
            if (url == null || url.compareTo("") == 0) {
                logger.debug("Invalid URL provided from Configuration. Looking for RunningInstance.");
                SimpleQuery serviceQuery = PersistenceAccountingService.queryForService();
                List addresses = ICFactory.client().submit((Query)serviceQuery);
                if (addresses == null || addresses.isEmpty()) {
                    String error = String.format("No Running Instance %s:%s found in the current context", SERVICE_CLASS, SERVICE_NAME);
                    throw new Exception(error);
                }
                Random random = new Random();
                int index = random.nextInt(addresses.size());
                url = (String)addresses.get(index);
            }
        }
        logger.debug("Accounting Service URL to be contacted is {}", (Object)url);
        this.httpCall = new HTTPCall(url, USER_AGENT);
    }

    protected void send(Record ... records) throws Exception {
        List<Record> list = Arrays.asList(records);
        String body = DSMapper.marshal(list);
        logger.trace("Going to persist {}s {}", (Object)Record.class.getSimpleName(), (Object)body);
        this.httpCall.call(String.class, PATH_SERVICE_INSERT_ACCOUNTING, HTTPCall.HTTPMETHOD.POST, body);
    }

    protected void reallyAccount(Record record) throws Exception {
        this.send(record);
    }

    protected void accountWithFallback(Record ... records) throws Exception {
        try {
            this.send(records);
        }
        catch (Throwable e) {
            super.accountWithFallback(records);
        }
    }

    public void close() throws Exception {
    }

    protected void openConnection() throws Exception {
    }

    protected void closeConnection() throws Exception {
    }

    public boolean isConnectionActive() throws Exception {
        return true;
    }

    protected void clean() throws Exception {
    }

    static {
        classFormat = "$resource/Profile/ServiceClass/text() eq '%1s'";
        nameFormat = "$resource/Profile/ServiceName/text() eq '%1s'";
        statusFormat = "$resource/Profile/DeploymentData/Status/text() eq 'ready'";
        containsFormat = "$entry/@EntryName eq '%1s'";
    }
}

