/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.scan;

import java.util.HashSet;
import java.util.Set;
import org.gcube.common.scan.scanners.resource.JarResourceScanner;
import org.gcube.common.scan.scanners.resource.ResourceScanner;
import org.gcube.common.scan.scanners.url.DirScanner;
import org.gcube.common.scan.scanners.url.ExcludeScanner;
import org.gcube.common.scan.scanners.url.JarFileScanner;
import org.gcube.common.scan.scanners.url.JarJarScanner;
import org.gcube.common.scan.scanners.url.URLScanner;

public class Configuration {
    static Set<URLScanner> urlScanners = new HashSet<URLScanner>();
    static Set<ResourceScanner> resourceScanners = new HashSet<ResourceScanner>();

    public static void register(URLScanner ... scanners) {
        for (URLScanner scanner : scanners) {
            urlScanners.add(scanner);
        }
    }

    public static void register(ResourceScanner ... scanners) {
        for (ResourceScanner scanner : scanners) {
            resourceScanners.add(scanner);
        }
    }

    static {
        Configuration.register(new DirScanner(), new JarFileScanner(), new JarJarScanner(), new ExcludeScanner());
        Configuration.register(new JarResourceScanner());
    }
}

