/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.queries.templates.impl.entities;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.informationsystem.base.impl.entities.EntityElementImpl;
import org.gcube.informationsystem.queries.templates.reference.entities.QueryTemplate;
import org.gcube.informationsystem.queries.templates.reference.properties.TemplateVariable;

@JsonTypeName(value="QueryTemplate")
public class QueryTemplateImpl
extends EntityElementImpl
implements QueryTemplate {
    private static final long serialVersionUID = -1096809036997782113L;
    protected String name;
    protected String description;
    protected ObjectMapper objectMapper;
    protected JsonNode template;
    protected Map<String, TemplateVariable> templateVariables = new HashMap<String, TemplateVariable>();
    protected JsonNode params;

    public QueryTemplateImpl() {
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getTemplateAsString() throws JsonProcessingException {
        return this.objectMapper.writeValueAsString((Object)this.template);
    }

    @Override
    public void setTemplate(String template) throws JsonProcessingException, IOException {
        this.template = this.objectMapper.readTree(template);
    }

    @Override
    public JsonNode getTemplate() {
        return this.template;
    }

    @Override
    public void setTemplate(JsonNode template) {
        this.template = template;
    }

    @Override
    public Map<String, TemplateVariable> getTemplateVariables() {
        return this.templateVariables;
    }

    @Override
    public void addTemplateVariable(TemplateVariable templateVariable) {
        String name = templateVariable.getName();
        this.templateVariables.put(name, templateVariable);
    }

    @Override
    public ObjectNode getParamsFromDefaultValues() {
        ObjectNode objectNode = this.objectMapper.createObjectNode();
        for (TemplateVariable tv : this.templateVariables.values()) {
            objectNode.put(tv.getName(), tv.getDefaultValue());
        }
        return objectNode;
    }

    @Override
    public JsonNode getJsonQuery() throws Exception {
        ObjectNode objectNode = this.getParamsFromDefaultValues();
        return this.getJsonQuery((JsonNode)objectNode);
    }

    protected JsonNode replaceVariables(JsonNode jsonNode) throws Exception {
        Iterator fieldNames = jsonNode.fieldNames();
        block5: while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode node = jsonNode.get(fieldName);
            switch (node.getNodeType()) {
                case OBJECT: {
                    node = this.replaceVariables(node);
                    ((ObjectNode)jsonNode).set(fieldName, node);
                    break;
                }
                case ARRAY: {
                    ArrayNode arrayNode = (ArrayNode)node;
                    for (int i = 0; i < arrayNode.size(); ++i) {
                        JsonNode arrayElement = arrayNode.get(i);
                        arrayElement = this.replaceVariables(arrayElement);
                        arrayNode.set(i, arrayElement);
                    }
                    continue block5;
                }
                case STRING: {
                    String value = node.asText();
                    if (!this.templateVariables.containsKey(value)) break;
                    JsonNode jn = this.params.get(value);
                    if (jn == null) {
                        throw new Exception("No value provided for " + value + " variables");
                    }
                    ((ObjectNode)jsonNode).set(fieldName, jn);
                    break;
                }
            }
        }
        return jsonNode;
    }

    @Override
    public JsonNode getJsonQuery(JsonNode values) throws Exception {
        this.params = values;
        JsonNode query = this.template.deepCopy();
        query = this.replaceVariables(query);
        return query;
    }
}

