/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.security;

import java.util.concurrent.Callable;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizedTasks {
    private static Logger logger = LoggerFactory.getLogger(AuthorizedTasks.class);

    public static <V> Callable<V> bind(final Callable<V> task) {
        final Secret secret = SecretManagerProvider.get();
        return new Callable<V>(){

            @Override
            public V call() throws Exception {
                SecretManagerProvider.set(secret);
                try {
                    logger.info("setting on authorized task context {} ", (Object)secret.getContext());
                    Object v = task.call();
                    return v;
                }
                finally {
                    SecretManagerProvider.reset();
                }
            }
        };
    }

    public static <V> Runnable bind(final Runnable task) {
        final Secret secret = SecretManagerProvider.get();
        return new Runnable(){

            @Override
            public void run() {
                SecretManagerProvider.set(secret);
                try {
                    logger.info("setting on authorized task context {} ", (Object)secret.getContext());
                    task.run();
                }
                finally {
                    SecretManagerProvider.reset();
                }
            }
        };
    }

    public static void executeSafely(Runnable task, Secret secret) {
        Secret previousSecret = SecretManagerProvider.get();
        try {
            SecretManagerProvider.set(secret);
            task.run();
        }
        finally {
            SecretManagerProvider.set(previousSecret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeSafely(Callable<T> task, Secret secret) throws Throwable {
        Secret previousSecret = SecretManagerProvider.get();
        try {
            SecretManagerProvider.set(secret);
            T t = task.call();
            return t;
        }
        finally {
            SecretManagerProvider.set(previousSecret);
        }
    }
}

