/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.context.container;

import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.UUID;
import org.gcube.common.events.Hub;
import org.gcube.common.security.factories.AuthorizationProvider;
import org.gcube.smartgears.configuration.PersistenceConfiguration;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.context.Properties;
import org.gcube.smartgears.context.container.ContainerContext;
import org.gcube.smartgears.lifecycle.container.ContainerLifecycle;
import org.gcube.smartgears.persistence.PersistenceWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultContainerContext
implements ContainerContext {
    private static Logger log = LoggerFactory.getLogger(DefaultContainerContext.class);
    private final ContainerConfiguration configuration;
    private final ContainerLifecycle lifecycle;
    private final Properties properties;
    private final Hub hub;
    private final AuthorizationProvider authorizationProvider;
    private final String id;
    private final PersistenceWriter persistenceWriter;

    public DefaultContainerContext(ContainerConfiguration configuration, Hub hub, ContainerLifecycle lifecycle, AuthorizationProvider authProvider, Properties properties) {
        this.configuration = configuration;
        this.hub = hub;
        this.lifecycle = lifecycle;
        this.properties = properties;
        this.authorizationProvider = authProvider;
        PersistenceConfiguration persistenceWriterConf = configuration.persistenceConfiguration();
        try {
            this.persistenceWriter = persistenceWriterConf.getImplementationClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.persistenceWriter.configure(persistenceWriterConf.getWriterConfiguration());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        File file = this.persistenceWriter.file("ghn.xml");
        String id = null;
        if (file.exists()) {
            log.info("loading persisted state for container");
            try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));){
                id = (String)ois.readObject();
            }
            catch (Exception e) {
                log.error("error loading persisted state, creating new uuid", (Throwable)e);
            }
        }
        if (id == null) {
            id = UUID.randomUUID().toString();
            log.info("container id created is {}", (Object)id);
        }
        this.id = id;
    }

    @Override
    public ContainerConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public ContainerLifecycle lifecycle() {
        return this.lifecycle;
    }

    @Override
    public Hub events() {
        return this.hub;
    }

    @Override
    public PersistenceWriter persistenceWriter() {
        return this.persistenceWriter;
    }

    @Override
    public Properties properties() {
        return this.properties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public AuthorizationProvider authorizationProvider() {
        return this.authorizationProvider;
    }
}

