/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.resources.gcore.common;

import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlAnyElement;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.resources.gcore.utils.Utils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AnyWrapper {
    private Element root = Utils.newDocument().getDocumentElement();
    @XmlAnyElement
    private List<Element> elements;

    public Element root() {
        return this.root;
    }

    private void afterUnmarshal(Unmarshaller unmarshaller, Object parent) {
        if (this.elements != null) {
            for (Element e : this.elements) {
                this.root.appendChild(this.root.getOwnerDocument().adoptNode(e));
            }
        }
        this.elements = null;
    }

    private void beforeMarshal(Marshaller marshaller) {
        this.elements = new ArrayList<Element>();
        NodeList list = this.root.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (node.getNodeType() != 1) continue;
            this.elements.add((Element)node);
        }
    }

    public String toString() {
        return "[element=" + this.root + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.root == null ? 0 : this.root.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnyWrapper other = (AnyWrapper)obj;
        if (this.root != null && other.root != null) {
            this.root.normalize();
            other.root.normalize();
        }
        return !(this.root == null ? other.root != null : !this.root.isEqualNode(other.root));
    }
}

