/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.managers;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.gcube.common.authorization.library.exception.AuthorizationException;
import org.gcube.smartgears.configuration.application.GCubeExclude;
import org.gcube.smartgears.configuration.application.GCubeInclude;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.context.application.DefaultApplicationContext;
import org.gcube.smartgears.handlers.application.ApplicationPipeline;
import org.gcube.smartgears.handlers.application.RequestEvent;
import org.gcube.smartgears.handlers.application.RequestHandler;
import org.gcube.smartgears.handlers.application.ResponseEvent;
import org.gcube.smartgears.handlers.application.request.RequestError;
import org.gcube.smartgears.handlers.application.request.RequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestManager
implements Filter {
    private static Logger log = LoggerFactory.getLogger(RequestManager.class);
    private final ApplicationContext context;
    private final String servlet;
    private final List<RequestHandler> handlers;

    public RequestManager(ApplicationContext context, String servletName, List<RequestHandler> handlers) {
        this.context = context;
        this.servlet = servletName;
        this.handlers = handlers;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httprequest = (HttpServletRequest)request;
        HttpServletResponse httpresponse = (HttpServletResponse)response;
        List<RequestHandler> filterHandlers = this.getPipelineHandlers(httprequest, this.handlers);
        if (filterHandlers.isEmpty()) {
            log.trace("filtered handlers are empty");
            chain.doFilter(request, response);
        } else {
            ApplicationPipeline<RequestHandler> pipeline = new ApplicationPipeline<RequestHandler>(filterHandlers);
            log.trace("filtered handler for this call are {}", filterHandlers);
            DefaultApplicationContext ctx = new DefaultApplicationContext(this.context);
            RequestEvent event = new RequestEvent(this.servlet, ctx, httprequest, httpresponse);
            try {
                pipeline.forward(event);
            }
            catch (Throwable t) {
                log.error("error in doFilter, forward", t);
                this.handleError(httprequest, httpresponse, t);
                return;
            }
            try {
                chain.doFilter(request, response);
            }
            catch (ServletException t) {
                log.error("error in doFilter", (Throwable)t);
                this.handleError(httprequest, httpresponse, t.getRootCause());
            }
            ResponseEvent responseEvent = new ResponseEvent(this.servlet, ctx, httprequest, httpresponse);
            try {
                pipeline.reverse().forward(responseEvent);
            }
            catch (Throwable t) {
                log.error("error in doFilter, reverse", t);
                this.handleError(httprequest, httpresponse, t);
                return;
            }
        }
    }

    private List<RequestHandler> getPipelineHandlers(HttpServletRequest request, List<RequestHandler> handlersToFilter) {
        String query = request.getQueryString();
        log.trace("servletPath is {} and pathInfo is {}", (Object)request.getServletPath(), (Object)request.getPathInfo());
        if ("wsdl".equals(query) || "wsdl=1".equals(query) || request.getServletPath().equals("/gcube/resource")) {
            return Collections.emptyList();
        }
        Object path = request.getServletPath() == null ? "" : request.getServletPath();
        path = (String)path + (request.getPathInfo() == null ? "" : request.getPathInfo());
        log.trace("check which handler should be excluded {}", path);
        if (!this.context.configuration().excludes().isEmpty()) {
            log.debug("excludes are not empty");
            for (GCubeExclude exclude : this.context.configuration().excludes()) {
                String excludePath = exclude.getPath();
                log.debug("exclude is {}", (Object)exclude);
                if (!"*".equals(excludePath) && (!excludePath.endsWith("*") || path == null || !((String)path).startsWith(excludePath.substring(0, excludePath.length() - 2))) && !excludePath.equals(path) && (!((String)path).endsWith("/") || !excludePath.equals(((String)path).substring(0, ((String)path).length() - 1)))) continue;
                if (exclude.getHandlers().isEmpty()) {
                    List unfilterables = handlersToFilter.stream().filter(RequestHandler::isUnfiltrable).collect(Collectors.toList());
                    log.trace("exclude handler is empty so unfilterable handlers are {}", unfilterables);
                    return handlersToFilter.stream().filter(RequestHandler::isUnfiltrable).collect(Collectors.toList());
                }
                ArrayList<RequestHandler> filteredHandlers = new ArrayList<RequestHandler>();
                for (RequestHandler rh : handlersToFilter) {
                    if (!rh.isUnfiltrable() && exclude.getHandlers().contains(rh.getName())) continue;
                    filteredHandlers.add(rh);
                }
                return filteredHandlers;
            }
        } else if (!this.context.configuration().includes().isEmpty()) {
            for (GCubeInclude include : this.context.configuration().includes()) {
                String includePath = include.getPath();
                log.trace("include is {}", (Object)include);
                if (!"*".equals(includePath) && (!includePath.endsWith("*") || path == null || !((String)path).startsWith(includePath.substring(0, includePath.length() - 2))) && !includePath.equals(path) && (!((String)path).endsWith("/") || !includePath.equals(((String)path).substring(0, ((String)path).length() - 1)))) continue;
                if (include.getHandlers().isEmpty()) {
                    return handlersToFilter;
                }
                ArrayList<RequestHandler> filteredHandlers = new ArrayList<RequestHandler>();
                for (RequestHandler rh : handlersToFilter) {
                    if (!rh.isUnfiltrable() && !include.getHandlers().contains(rh.getName())) continue;
                    filteredHandlers.add(rh);
                }
                return filteredHandlers;
            }
            return new ArrayList<RequestHandler>();
        }
        log.trace("returning original handlers");
        return handlersToFilter;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            for (RequestHandler handler : this.handlers) {
                handler.start(this.context);
            }
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    public void destroy() {
        for (RequestHandler handler : this.handlers) {
            try {
                handler.stop();
            }
            catch (Throwable t) {
                log.error("cannot terminate handler {} for application {} ", (Object)handler, (Object)this.context.name());
            }
        }
    }

    private void handleError(HttpServletRequest request, HttpServletResponse response, Throwable t) throws IOException {
        if (t instanceof AuthorizationException) {
            response.setStatus(403);
            response.getWriter().write("Error (Forbidden) : " + t.getMessage() + "\nStacktrace:\n");
            t.printStackTrace(response.getWriter());
            response.flushBuffer();
        } else {
            RequestError error;
            RequestError requestError = error = t instanceof RequestException ? ((RequestException)RequestException.class.cast(t)).error() : RequestError.application_error;
            if (!response.isCommitted()) {
                response.resetBuffer();
            }
            if (error == RequestError.request_not_authorized_error) {
                response.setHeader("WWW-Authenticate", "Basic realm=\"Smartgears\"");
                log.info("setting WWW-Authenticate to response header");
            }
            response.setStatus(error.code());
            response.getWriter().write("Error (" + error.code() + ") : " + error.message() + "\nStacktrace:\n");
            t.printStackTrace(response.getWriter());
            response.flushBuffer();
        }
    }
}

