/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.types.knowledge;

import java.util.Calendar;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.model.knowledge.ModelKnowledge;
import org.gcube.informationsystem.model.knowledge.TypesDiscoverer;
import org.gcube.informationsystem.types.knowledge.TypeInformation;
import org.gcube.informationsystem.types.reference.Type;

public class TypesKnowledge {
    private static TypesKnowledge instance;
    public static final long DEFAULT_EXPIRING_TIMEOUT;
    protected boolean initialized = false;
    public int expiringTimeout = (int)DEFAULT_EXPIRING_TIMEOUT;
    protected Calendar creationTime;
    protected Calendar expiringTime;
    protected ModelKnowledge<Type, TypeInformation> modelKnowledge = new ModelKnowledge(new TypeInformation());
    protected TypesDiscoverer<Type> typesDiscoverer;

    public static synchronized TypesKnowledge getInstance() {
        if (instance == null) {
            instance = new TypesKnowledge();
        }
        return instance;
    }

    public void setExpiringTimeout(int expiringTimeout) {
        this.expiringTimeout = expiringTimeout;
    }

    public TypesDiscoverer<Type> getTypesDiscoverer() {
        return this.typesDiscoverer;
    }

    public void setTypesDiscoverer(TypesDiscoverer<Type> typesDiscoverer) {
        this.typesDiscoverer = typesDiscoverer;
    }

    public ModelKnowledge<Type, TypeInformation> getModelKnowledge() {
        if (!this.initialized) {
            this.discover();
        } else {
            Calendar now = Calendar.getInstance();
            if (now.after(this.expiringTime)) {
                this.renew();
            }
        }
        return this.modelKnowledge;
    }

    protected synchronized void init(boolean forceReinitialization) {
        if (this.typesDiscoverer != null && (!this.initialized || forceReinitialization)) {
            AccessType[] modelTypes;
            this.initialized = false;
            this.modelKnowledge = new ModelKnowledge(new TypeInformation());
            for (AccessType modelType : modelTypes = AccessType.getModelTypes()) {
                Collection<Type> types = this.typesDiscoverer.discover(modelType);
                this.modelKnowledge.addAllType(types);
            }
            this.initialized = true;
            this.creationTime = Calendar.getInstance();
            this.expiringTime = Calendar.getInstance();
            this.expiringTime.setTimeInMillis(this.creationTime.getTimeInMillis());
            this.expiringTime.add(14, -1);
            this.expiringTime.add(14, this.expiringTimeout);
        }
    }

    public void discover() {
        this.init(false);
    }

    public void renew() {
        this.init(true);
    }

    static {
        DEFAULT_EXPIRING_TIMEOUT = TimeUnit.HOURS.toMillis(6L);
    }
}

