/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.utils;

import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.gcube.informationsystem.types.PropertyTypeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeUtility {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public static void checkRegex(String regex, String text) {
        try {
            Matcher matcher;
            if (regex == null) {
                return;
            }
            Pattern pattern = Pattern.compile(regex);
            if (text != null && !(matcher = pattern.matcher(text)).find()) {
                throw new RuntimeException("The value '" + text + "' does not match the requested regular expression '" + regex + "'.");
            }
        }
        catch (PatternSyntaxException e) {
            throw new RuntimeException("'" + regex + "' is not a valid regular expression", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    public static String evaluateNullForDefaultValue(String defaultValueAsString) {
        if (defaultValueAsString == null || defaultValueAsString.compareTo("null") == 0) {
            return null;
        }
        return defaultValueAsString;
    }

    public static Object evaluateDefaultValueStringAccordingBaseType(PropertyTypeName.BaseType baseType, String defaultValueAsString) {
        if (defaultValueAsString == null || defaultValueAsString.compareTo("null") == 0) {
            return null;
        }
        if (defaultValueAsString != null) {
            switch (baseType) {
                case BOOLEAN: {
                    return Boolean.parseBoolean(defaultValueAsString);
                }
                case INTEGER: {
                    return Integer.parseInt(defaultValueAsString);
                }
                case SHORT: {
                    return Short.parseShort(defaultValueAsString);
                }
                case LONG: {
                    return Long.parseLong(defaultValueAsString);
                }
                case FLOAT: {
                    return Float.valueOf(Float.parseFloat(defaultValueAsString));
                }
                case DOUBLE: {
                    return Double.parseDouble(defaultValueAsString);
                }
                case DATE: {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z");
                    try {
                        return sdf.parse(defaultValueAsString);
                    }
                    catch (ParseException e) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("Error while parsing annotated default ");
                        stringBuffer.append(Date.class.getSimpleName());
                        stringBuffer.append(". The provided default value is '");
                        stringBuffer.append(defaultValueAsString);
                        stringBuffer.append("' which does not match the pattern '");
                        stringBuffer.append("yyyy-MM-dd HH:mm:ss.SSS Z");
                        stringBuffer.append("'.");
                        throw new RuntimeException(stringBuffer.toString(), e);
                    }
                }
                case STRING: {
                    return defaultValueAsString;
                }
                case BINARY: {
                    return defaultValueAsString.getBytes();
                }
                case BYTE: {
                    return Byte.parseByte(defaultValueAsString);
                }
                case PROPERTY: {
                    return null;
                }
            }
        }
        return null;
    }
}

