/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.scope.impl;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gcube.common.scope.api.ServiceMap;
import org.gcube.common.scope.impl.ServiceMapAdapter;

@XmlRootElement(name="service-map")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DefaultServiceMap
implements ServiceMap {
    @XmlAttribute
    private String scope;
    @XmlAttribute
    private String version;
    @XmlJavaTypeAdapter(value=ServiceMapAdapter.class)
    Map<String, String> services = new LinkedHashMap<String, String>();

    @Override
    public String scope() {
        return this.scope;
    }

    @Override
    public String version() {
        return this.version;
    }

    @Override
    public String endpoint(String service) {
        String endpoint = this.services.get(service);
        if (endpoint == null) {
            throw new IllegalArgumentException("unknown service " + service);
        }
        return endpoint;
    }

    public String toString() {
        return "DefaultServiceMap [scope=" + this.scope + ", version=" + this.version + ", services=" + this.services + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        result = 31 * result + (this.services == null ? 0 : this.services.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultServiceMap other = (DefaultServiceMap)obj;
        if (this.scope == null ? other.scope != null : !this.scope.equals(other.scope)) {
            return false;
        }
        if (this.services == null ? other.services != null : !this.services.equals(other.services)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

