/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.security;

import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import javax.crypto.SecretKey;
import org.gcube.io.jsonwebtoken.impl.security.AbstractAsymmetricJwkBuilder;
import org.gcube.io.jsonwebtoken.impl.security.AbstractJwk;
import org.gcube.io.jsonwebtoken.impl.security.AbstractJwkBuilder;
import org.gcube.io.jsonwebtoken.impl.security.DefaultJwkContext;
import org.gcube.io.jsonwebtoken.impl.security.EdwardsCurve;
import org.gcube.io.jsonwebtoken.impl.security.JwkContext;
import org.gcube.io.jsonwebtoken.impl.security.KeyPairs;
import org.gcube.io.jsonwebtoken.impl.security.KeysBridge;
import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.lang.Strings;
import org.gcube.io.jsonwebtoken.security.DynamicJwkBuilder;
import org.gcube.io.jsonwebtoken.security.EcPrivateJwkBuilder;
import org.gcube.io.jsonwebtoken.security.EcPublicJwkBuilder;
import org.gcube.io.jsonwebtoken.security.Jwk;
import org.gcube.io.jsonwebtoken.security.OctetPrivateJwkBuilder;
import org.gcube.io.jsonwebtoken.security.OctetPublicJwkBuilder;
import org.gcube.io.jsonwebtoken.security.PrivateJwkBuilder;
import org.gcube.io.jsonwebtoken.security.PublicJwkBuilder;
import org.gcube.io.jsonwebtoken.security.RsaPrivateJwkBuilder;
import org.gcube.io.jsonwebtoken.security.RsaPublicJwkBuilder;
import org.gcube.io.jsonwebtoken.security.SecretJwkBuilder;
import org.gcube.io.jsonwebtoken.security.UnsupportedKeyException;

public class DefaultDynamicJwkBuilder<K extends Key, J extends Jwk<K>>
extends AbstractJwkBuilder<K, J, DynamicJwkBuilder<K, J>>
implements DynamicJwkBuilder<K, J> {
    public DefaultDynamicJwkBuilder() {
        this(new DefaultJwkContext());
    }

    public DefaultDynamicJwkBuilder(JwkContext<K> ctx) {
        super(ctx);
    }

    public SecretJwkBuilder key(SecretKey key) {
        return new AbstractJwkBuilder.DefaultSecretJwkBuilder(this.newContext(key));
    }

    public RsaPublicJwkBuilder key(RSAPublicKey key) {
        return new AbstractAsymmetricJwkBuilder.DefaultRsaPublicJwkBuilder(this.newContext(key));
    }

    public RsaPrivateJwkBuilder key(RSAPrivateKey key) {
        return new AbstractAsymmetricJwkBuilder.DefaultRsaPrivateJwkBuilder(this.newContext(key));
    }

    public EcPublicJwkBuilder key(ECPublicKey key) {
        return new AbstractAsymmetricJwkBuilder.DefaultEcPublicJwkBuilder(this.newContext(key));
    }

    public EcPrivateJwkBuilder key(ECPrivateKey key) {
        return new AbstractAsymmetricJwkBuilder.DefaultEcPrivateJwkBuilder(this.newContext(key));
    }

    private static UnsupportedKeyException unsupportedKey(Key key, Exception e) {
        String msg = "There is no builder that supports specified key [" + KeysBridge.toString(key) + "].";
        return new UnsupportedKeyException(msg, (Throwable)e);
    }

    public <A extends PublicKey, B extends PrivateKey> PublicJwkBuilder<A, B, ?, ?, ?, ?> key(A key) {
        if (key instanceof RSAPublicKey) {
            return this.key((RSAPublicKey)key);
        }
        if (key instanceof ECPublicKey) {
            return this.key((ECPublicKey)key);
        }
        try {
            return this.octetKey(key);
        }
        catch (Exception e) {
            throw DefaultDynamicJwkBuilder.unsupportedKey(key, e);
        }
    }

    public <A extends PublicKey, B extends PrivateKey> PrivateJwkBuilder<B, A, ?, ?, ?> key(B key) {
        Assert.notNull(key, (String)"Key cannot be null.");
        if (key instanceof RSAPrivateKey) {
            return this.key((RSAPrivateKey)key);
        }
        if (key instanceof ECPrivateKey) {
            return this.key((ECPrivateKey)key);
        }
        try {
            return this.octetKey(key);
        }
        catch (Exception e) {
            throw DefaultDynamicJwkBuilder.unsupportedKey(key, e);
        }
    }

    public <A extends PublicKey, B extends PrivateKey> OctetPublicJwkBuilder<A, B> octetKey(A key) {
        return new AbstractAsymmetricJwkBuilder.DefaultOctetPublicJwkBuilder(this.newContext(key));
    }

    public <A extends PrivateKey, B extends PublicKey> OctetPrivateJwkBuilder<A, B> octetKey(A key) {
        return new AbstractAsymmetricJwkBuilder.DefaultOctetPrivateJwkBuilder(this.newContext(key));
    }

    public <A extends PublicKey, B extends PrivateKey> PublicJwkBuilder<A, B, ?, ?, ?, ?> chain(List<X509Certificate> chain) throws UnsupportedKeyException {
        Assert.notEmpty(chain, (String)"chain cannot be null or empty.");
        X509Certificate cert = (X509Certificate)Assert.notNull((Object)chain.get(0), (String)"The first X509Certificate cannot be null.");
        PublicKey key = (PublicKey)Assert.notNull((Object)cert.getPublicKey(), (String)"The first X509Certificate's PublicKey cannot be null.");
        return (PublicJwkBuilder)this.key(key).x509Chain(chain);
    }

    public RsaPublicJwkBuilder rsaChain(List<X509Certificate> chain) {
        Assert.notEmpty(chain, (String)"X509Certificate chain cannot be empty.");
        X509Certificate cert = chain.get(0);
        PublicKey key = cert.getPublicKey();
        RSAPublicKey pubKey = KeyPairs.assertKey(key, RSAPublicKey.class, "The first X509Certificate's ");
        return (RsaPublicJwkBuilder)this.key(pubKey).x509Chain(chain);
    }

    public EcPublicJwkBuilder ecChain(List<X509Certificate> chain) {
        Assert.notEmpty(chain, (String)"X509Certificate chain cannot be empty.");
        X509Certificate cert = chain.get(0);
        PublicKey key = cert.getPublicKey();
        ECPublicKey pubKey = KeyPairs.assertKey(key, ECPublicKey.class, "The first X509Certificate's ");
        return (EcPublicJwkBuilder)this.key(pubKey).x509Chain(chain);
    }

    public <A extends PrivateKey, B extends PublicKey> OctetPrivateJwkBuilder<A, B> octetKeyPair(KeyPair pair) {
        PublicKey pub = KeyPairs.getKey(pair, PublicKey.class);
        PrivateKey priv = KeyPairs.getKey(pair, PrivateKey.class);
        EdwardsCurve.assertEdwards(pub);
        EdwardsCurve.assertEdwards(priv);
        return (OctetPrivateJwkBuilder)this.octetKey(priv).publicKey(pub);
    }

    public <A extends PublicKey, B extends PrivateKey> OctetPublicJwkBuilder<A, B> octetChain(List<X509Certificate> chain) {
        Assert.notEmpty(chain, (String)"X509Certificate chain cannot be empty.");
        X509Certificate cert = chain.get(0);
        PublicKey key = cert.getPublicKey();
        Assert.notNull((Object)key, (String)"The first X509Certificate's PublicKey cannot be null.");
        EdwardsCurve.assertEdwards(key);
        return (OctetPublicJwkBuilder)this.octetKey(key).x509Chain(chain);
    }

    public RsaPrivateJwkBuilder rsaKeyPair(KeyPair pair) {
        RSAPublicKey pub = KeyPairs.getKey(pair, RSAPublicKey.class);
        RSAPrivateKey priv = KeyPairs.getKey(pair, RSAPrivateKey.class);
        return (RsaPrivateJwkBuilder)this.key(priv).publicKey((PublicKey)pub);
    }

    public EcPrivateJwkBuilder ecKeyPair(KeyPair pair) {
        ECPublicKey pub = KeyPairs.getKey(pair, ECPublicKey.class);
        ECPrivateKey priv = KeyPairs.getKey(pair, ECPrivateKey.class);
        return (EcPrivateJwkBuilder)this.key(priv).publicKey((PublicKey)pub);
    }

    public <A extends PublicKey, B extends PrivateKey> PrivateJwkBuilder<B, A, ?, ?, ?> keyPair(KeyPair keyPair) throws UnsupportedKeyException {
        PublicKey pub = KeyPairs.getKey(keyPair, PublicKey.class);
        PrivateKey priv = KeyPairs.getKey(keyPair, PrivateKey.class);
        return this.key(priv).publicKey(pub);
    }

    @Override
    public J build() {
        if (Strings.hasText((String)((String)((JwkContext)this.DELEGATE).get(AbstractJwk.KTY)))) {
            this.setDelegate(this.jwkFactory.newContext((JwkContext)this.DELEGATE, ((JwkContext)this.DELEGATE).getKey()));
        }
        return super.build();
    }
}

