/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.security;

import java.security.Provider;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gcube.io.jsonwebtoken.impl.ParameterMap;
import org.gcube.io.jsonwebtoken.impl.lang.Parameter;
import org.gcube.io.jsonwebtoken.impl.lang.Parameters;
import org.gcube.io.jsonwebtoken.impl.security.AbstractJwkBuilder;
import org.gcube.io.jsonwebtoken.impl.security.AbstractSecurityBuilder;
import org.gcube.io.jsonwebtoken.impl.security.DefaultJwkSet;
import org.gcube.io.jsonwebtoken.impl.security.JwkBuilderSupplier;
import org.gcube.io.jsonwebtoken.impl.security.JwkConverter;
import org.gcube.io.jsonwebtoken.impl.security.JwkSetConverter;
import org.gcube.io.jsonwebtoken.lang.Collections;
import org.gcube.io.jsonwebtoken.security.Jwk;
import org.gcube.io.jsonwebtoken.security.JwkSet;
import org.gcube.io.jsonwebtoken.security.JwkSetBuilder;
import org.gcube.io.jsonwebtoken.security.KeyOperationPolicy;

public class DefaultJwkSetBuilder
extends AbstractSecurityBuilder<JwkSet, JwkSetBuilder>
implements JwkSetBuilder {
    private KeyOperationPolicy operationPolicy = AbstractJwkBuilder.DEFAULT_OPERATION_POLICY;
    private JwkSetConverter converter = new JwkSetConverter();
    private ParameterMap map = new ParameterMap(Parameters.registry(DefaultJwkSet.KEYS));

    public JwkSetBuilder delete(String key) {
        this.map.remove(key);
        return this;
    }

    public JwkSetBuilder empty() {
        this.map.clear();
        return this;
    }

    public JwkSetBuilder add(String key, Object value) {
        this.map.put(key, value);
        return this;
    }

    public JwkSetBuilder add(Map<? extends String, ?> m) {
        this.map.putAll(m);
        return this;
    }

    private JwkSetBuilder refresh() {
        JwkConverter jwkConverter = new JwkConverter(new JwkBuilderSupplier(this.provider, this.operationPolicy));
        this.converter = new JwkSetConverter(jwkConverter, this.converter.isIgnoreUnsupported());
        Parameter<Set<Jwk<?>>> param = DefaultJwkSet.param(jwkConverter);
        this.map = new ParameterMap(Parameters.registry(param), this.map, true);
        Set<Jwk<?>> jwks = this.map.get(param);
        if (!Collections.isEmpty(jwks)) {
            for (Jwk<?> jwk : jwks) {
                this.operationPolicy.validate((Collection)jwk.getOperations());
            }
        }
        return this;
    }

    @Override
    public JwkSetBuilder provider(Provider provider) {
        super.provider(provider);
        return this.refresh();
    }

    public JwkSetBuilder operationPolicy(KeyOperationPolicy policy) throws IllegalArgumentException {
        this.operationPolicy = policy != null ? policy : AbstractJwkBuilder.DEFAULT_OPERATION_POLICY;
        return this.refresh();
    }

    Collection<Jwk<?>> ensureKeys() {
        Collection keys = this.map.get(DefaultJwkSet.KEYS);
        return Collections.isEmpty((Collection)keys) ? new LinkedHashSet() : keys;
    }

    public JwkSetBuilder add(Jwk<?> jwk) {
        if (jwk != null) {
            this.operationPolicy.validate((Collection)jwk.getOperations());
            Collection<Jwk<?>> keys = this.ensureKeys();
            keys.add(jwk);
            this.keys(keys);
        }
        return this;
    }

    public JwkSetBuilder add(Collection<Jwk<?>> c) {
        if (!Collections.isEmpty(c)) {
            for (Jwk<?> jwk : c) {
                this.add(jwk);
            }
        }
        return this;
    }

    public JwkSetBuilder keys(Collection<Jwk<?>> c) {
        return this.add(DefaultJwkSet.KEYS.getId(), c);
    }

    public JwkSet build() {
        return this.converter.applyFrom(this.map);
    }
}

