/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.security;

import javax.crypto.SecretKey;
import org.gcube.io.jsonwebtoken.impl.security.DefaultKeyResult;
import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.security.DecryptionKeyRequest;
import org.gcube.io.jsonwebtoken.security.KeyAlgorithm;
import org.gcube.io.jsonwebtoken.security.KeyRequest;
import org.gcube.io.jsonwebtoken.security.KeyResult;
import org.gcube.io.jsonwebtoken.security.SecurityException;

public class DirectKeyAlgorithm
implements KeyAlgorithm<SecretKey, SecretKey> {
    static final String ID = "dir";

    public String getId() {
        return ID;
    }

    public KeyResult getEncryptionKey(KeyRequest<SecretKey> request) throws SecurityException {
        Assert.notNull(request, (String)"request cannot be null.");
        SecretKey key = (SecretKey)Assert.notNull((Object)request.getPayload(), (String)"Encryption key cannot be null.");
        return new DefaultKeyResult(key);
    }

    public SecretKey getDecryptionKey(DecryptionKeyRequest<SecretKey> request) throws SecurityException {
        Assert.notNull(request, (String)"request cannot be null.");
        return (SecretKey)Assert.notNull((Object)request.getKey(), (String)"Decryption key cannot be null.");
    }
}

