/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.persistence;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.gcube.common.security.AuthorizedTasks;
import org.gcube.common.security.factories.AuthorizationProvider;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.documentstore.configuration.LibraryConfigurationBinder;
import org.gcube.documentstore.persistence.ExecutorUtils;
import org.gcube.documentstore.persistence.FallbackPersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackendFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PersistenceBackendRediscover
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceBackendRediscover.class);
    protected final String context;
    protected final String initialValidContext;
    protected final FallbackPersistenceBackend fallbackPersistenceBackend;
    private ScheduledFuture<?> scheduledThread;

    public PersistenceBackendRediscover(String context, FallbackPersistenceBackend fallbackPersistenceBackend, long initialDelay, long delay, TimeUnit timeUnit) {
        logger.trace("Going to initialize {} for context {} with initial delay {} {} and delay {} {}", new Object[]{PersistenceBackendRediscover.class.getSimpleName(), context, initialDelay, timeUnit, delay, timeUnit});
        this.context = context;
        try {
            Secret secret = SecretManagerProvider.get();
            this.initialValidContext = secret.getContext();
        }
        catch (Throwable t) {
            String error = "It was not possible to obtain the initial context in " + PersistenceBackendRediscover.class.getSimpleName();
            logger.error(error, t);
            throw new RuntimeException(error, t);
        }
        logger.trace("Reference context is {} Initial context is {}", (Object)context, (Object)this.initialValidContext);
        this.fallbackPersistenceBackend = fallbackPersistenceBackend;
        this.scheduledThread = ExecutorUtils.PERSISTENCE_BACKEND_REDISCOVERY_POOL.scheduleAtFixedRate(this, initialDelay, delay, timeUnit);
    }

    @Override
    public void run() {
        try {
            logger.info("Trying to rediscover {} in initial context {} using generated credential", (Object)PersistenceBackend.class.getSimpleName(), (Object)this.initialValidContext);
            LibraryConfigurationBinder configurationBinder = LibraryConfigurationBinder.getInstance();
            AuthorizationProvider authorizationProvider = configurationBinder.getAuthorizationProvider();
            AuthorizedTasks.executeSafely((Runnable)new Runnable(){

                @Override
                public void run() {
                    PersistenceBackend rediscovered = PersistenceBackendFactory.rediscoverPersistenceBackend(PersistenceBackendRediscover.this.fallbackPersistenceBackend, PersistenceBackendRediscover.this.context);
                    if (!rediscovered.getClass().equals(PersistenceBackendRediscover.this.fallbackPersistenceBackend.getClass())) {
                        logger.trace("Another {} was found : {}. Shutting down {} Thread for context {}", new Object[]{PersistenceBackend.class.getSimpleName(), rediscovered.getClass().getSimpleName(), PersistenceBackendRediscover.class.getSimpleName(), PersistenceBackendRediscover.this.context});
                        PersistenceBackendRediscover.this.scheduledThread.cancel(true);
                    } else {
                        logger.trace("{} for context {} is still a {}. We will see if next time we will be more lucky.", (Object)PersistenceBackend.class.getSimpleName(), (Object)FallbackPersistenceBackend.class.getSimpleName());
                    }
                }
            }, (Secret)authorizationProvider.getSecretForContext(this.initialValidContext));
        }
        catch (Throwable t) {
            logger.info(". The attemp to rediscover {} in initial context {} failed using generated credential (Reason {})", (Object)PersistenceBackend.class.getSimpleName(), (Object)t.getMessage());
        }
    }
}

