package org.gcube.vomanagement.occi;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.List;

import cz.cesnet.cloud.occi.api.exception.CommunicationException;
import cz.cesnet.cloud.occi.core.Mixin;
import cz.cesnet.cloud.occi.exception.AmbiguousIdentifierException;
import cz.cesnet.cloud.occi.exception.InvalidAttributeValueException;

public interface JocciInterface {

	// path to CA certificates
	public void setTrustStore(String path);

	// path to proxy certificate
	public void setCertificate(String path);

	// connection to endpoint
	public void connect() throws CommunicationException;

	// returns the URI list of the computes available on the endpoint
	public List<URI> getComputeList();

	// returns the list of OS templates
	public List<Mixin> getOsTemplateList();

	// returns the list of resources templates
	public List<Mixin> getResourcesTemplateList();

	// create a VM on the site (parameters: OS templates from
	// getOsTemplateList(), Resources templates from getResourcesTemplateList(),
	// the name of the VM)
	public void createResourceAndDescribe(Mixin osTemplate, Mixin resourceTemplate,
			String vmName) throws InvalidAttributeValueException,
			AmbiguousIdentifierException, IOException;
	
	public void createResourceAndDescribe(Mixin osMixin, Mixin resourceMixin,
			String vmName, String script) throws InvalidAttributeValueException,
			AmbiguousIdentifierException, IOException;
	
	public void createResourceAndDescribe(Mixin osMixin, Mixin resourceMixin,
			String vmName, URL context) throws InvalidAttributeValueException,
			AmbiguousIdentifierException, IOException;
	
	public void createResourceAndDescribe(Mixin osMixin, Mixin resourceMixin,
			String vmName, File path) throws InvalidAttributeValueException,
			AmbiguousIdentifierException, IOException; 
	
	// start VM; do not use after createResourceAndDescribe()
	public void startResource(URI resourceType) throws InterruptedException;

	// stop VM
	public void stopResource(URI resourceType);

	// delete VM
	public void deleteResource(URI resourceType);

	public List<URI> getNetList();
	
	public List<URI> getStorageList();

	

}