/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vomagement.policymanagement.service.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vomagement.policymanagement.bean.PolicyBean;
import org.gcube.vomagement.policymanagement.bean.PolicySetBean;
import org.gcube.vomagement.policymanagement.bean.RuleBean;
import org.gcube.vomagement.policymanagement.impl.ArgusPolicyManagementClient;
import org.gcube.vomagement.policymanagement.service.RuleManager;
import org.ietf.jgss.GSSCredential;
import os.schema.policy._0._2.xacml.tc.names.oasis.EffectType;
import os.schema.policy._0._2.xacml.tc.names.oasis.IdReferenceType;
import os.schema.policy._0._2.xacml.tc.names.oasis.PolicySetType;
import os.schema.policy._0._2.xacml.tc.names.oasis.PolicyType;
import os.schema.policy._0._2.xacml.tc.names.oasis.RuleType;
import os.schema.policy._0._2.xacml.tc.names.oasis.TargetType;

public class ArgusRuleManager
implements RuleManager {
    private GCUBELog logger = new GCUBELog((Object)this);
    private String papUrl;
    private GSSCredential credential;

    public ArgusRuleManager(String papUrl, GSSCredential credential) throws Exception {
        this.papUrl = papUrl;
        this.credential = credential;
    }

    @Override
    public boolean addRule(String role, String resource, String operation, boolean permitted) {
        return this.addRule(role, resource, operation, permitted, false);
    }

    @Override
    public boolean addRule(String role, String resource, String operation, boolean permitted, boolean updateIfExists) {
        this.logger.debug((Object)"Adding new rule");
        this.logger.debug((Object)("Role " + role));
        this.logger.debug((Object)("Resource " + resource));
        this.logger.debug((Object)("Operation " + operation));
        PolicyBean bean = this.findPolicy(role, resource, operation);
        if (bean != null && updateIfExists) {
            this.logger.debug((Object)"Rule exists: the policy will be updated");
            return this.internalUpdateRule(bean, permitted);
        }
        if (bean != null) {
            this.logger.debug((Object)"Rule exists: use update policy instead");
            return false;
        }
        boolean response = new ArgusPolicyManagementClient(this.papUrl, this.credential).addRule(role, operation, resource, permitted) != null;
        this.logger.debug((Object)("Operation completed with result " + response));
        return response;
    }

    public boolean removePolicy(String resource, String operation) {
        this.logger.debug((Object)"Remove Policy");
        PolicySetType[] policySetList = new ArgusPolicyManagementClient(this.papUrl, this.credential).listPolicySets();
        List<PolicySetBean> policyIdList = this.findPolicySetsFromResource(policySetList, resource);
        List<PolicySetBean> removeEligibleList = this.findPolicyTypesFromOperation(policyIdList, resource, operation);
        boolean finalResoponse = true;
        if (removeEligibleList != null) {
            this.logger.debug((Object)"Triyng to remove policies");
            for (PolicySetBean psBean : removeEligibleList) {
                String policySetId = psBean.getId();
                this.logger.debug((Object)("Policy set id " + policySetId));
                boolean found = false;
                int i = 0;
                for (i = 0; i < policyIdList.size() && !found; ++i) {
                    if (!policySetList[i].getPolicySetId().equals(policySetId)) continue;
                    this.logger.debug((Object)"Policy set reference found");
                    found = true;
                }
                if (!found) continue;
                this.logger.debug((Object)"Removing policy reference");
                IdReferenceType[] references = policySetList[i].getPolicyIdReference();
                List<String> tobedeletedReferences = psBean.getPolicyIdReference();
                this.logger.debug((Object)"Building reference list");
                int oldIndex = 0;
                IdReferenceType[] newReferences = new IdReferenceType[references.length - tobedeletedReferences.size()];
                for (int u = 0; u < newReferences.length; ++u) {
                    if (!tobedeletedReferences.contains(references[oldIndex].get_value())) {
                        this.logger.debug((Object)("Adding in the new references list " + references[oldIndex].get_value()));
                        newReferences[u] = references[oldIndex];
                    }
                    ++oldIndex;
                }
                policySetList[i].setPolicyIdReference(newReferences);
                boolean partialResponse = new ArgusPolicyManagementClient(this.papUrl, this.credential).updatePolicySet(policySetList[i]);
                this.logger.debug((Object)("Policy references deleted " + partialResponse));
                finalResoponse = finalResoponse && partialResponse;
            }
            boolean purgeRsponse = new ArgusPolicyManagementClient(this.papUrl, this.credential).purge(true, true, true, true);
            this.logger.debug((Object)("Purge operation completed " + purgeRsponse));
        } else {
            this.logger.debug((Object)"No policy found");
        }
        return finalResoponse;
    }

    @Override
    public boolean updateRule(String role, String resource, String operation, boolean permitted) {
        this.logger.debug((Object)"Updating rule...");
        PolicyBean policy = this.findPolicy(role, resource, operation);
        return this.internalUpdateRule(policy, permitted);
    }

    @Override
    public boolean removeRule(String role, String resource, String operation) {
        this.logger.debug((Object)"Removing rule...");
        PolicyBean policy = this.findPolicy(role, resource, operation);
        boolean response = false;
        if (policy != null) {
            this.logger.debug((Object)"Policy reference found");
            this.logger.debug((Object)"Finding references");
            PolicyType pt = policy.getPolicyReference();
            RuleType rt = policy.getRuleReference();
            String ruleId = rt.getRuleId();
            this.logger.debug((Object)("Rule id " + ruleId));
            RuleType[] rules = pt.getRule();
            RuleType[] newRules = new RuleType[rules.length - 1];
            this.logger.debug((Object)"Removing rule...");
            int oldIndex = 0;
            for (int i = 0; i < newRules.length; ++i) {
                if (!rules[oldIndex].getRuleId().equals(ruleId)) {
                    this.logger.debug((Object)("Adding in the new list rule " + rules[oldIndex].getRuleId()));
                    newRules[i] = rules[oldIndex];
                }
                ++oldIndex;
            }
            this.logger.debug((Object)"New Rule list ready, updating Argus");
            pt.setRule(newRules);
            response = new ArgusPolicyManagementClient(this.papUrl, this.credential).updatePolicy(pt);
            this.logger.debug((Object)("Operation completed with result " + response));
            boolean purgeResponse = new ArgusPolicyManagementClient(this.papUrl, this.credential).purge(true, true, true, true);
            this.logger.debug((Object)("Purge Operation completed with result " + purgeResponse));
        }
        return response;
    }

    @Override
    public boolean resetPolicyManager() {
        this.logger.debug((Object)"Resetting Argus");
        boolean response = new ArgusPolicyManagementClient(this.papUrl, this.credential).eraseRepository();
        this.logger.debug((Object)("Operation completed with result " + response));
        return response;
    }

    @Override
    public List<RuleBean> listRules() {
        this.logger.debug((Object)"Loading all rules");
        return this.listRules(null, null, null);
    }

    @Override
    public List<RuleBean> listRules(String roleFilter, String resourceFilter, String operationFilter) {
        this.logger.debug((Object)"Finding policy ");
        if (roleFilter != null) {
            roleFilter = "urn:d4science:roles:role-values:" + roleFilter;
        }
        this.logger.debug((Object)("Role " + roleFilter));
        this.logger.debug((Object)("Resource " + resourceFilter));
        this.logger.debug((Object)("Operation " + operationFilter));
        ArrayList<RuleBean> response = new ArrayList<RuleBean>();
        PolicySetType[] policySetList = new ArgusPolicyManagementClient(this.papUrl, this.credential).listPolicySets();
        this.logger.debug((Object)"Policy set loaded");
        List<PolicySetBean> policySets = this.findPolicySetsFromResource(policySetList, resourceFilter);
        if (policySets != null) {
            for (PolicySetBean ps : policySets) {
                this.logger.debug((Object)("Policy set " + ps.getId()));
                List<PolicyBean> pBeans = this.findPoliciesFromOperationAndRole(this.getPolicyIds(ps), roleFilter, ps.getResource(), operationFilter);
                for (PolicyBean pb : pBeans) {
                    response.add(pb.getRuleBean());
                }
            }
        } else {
            this.logger.debug((Object)"No policy set found");
        }
        return response;
    }

    @Override
    public RuleBean getRule(String roleFilter, String resourceFilter, String operationFilter) {
        this.logger.debug((Object)"Getting requested rule...");
        List<RuleBean> response = this.listRules(roleFilter, resourceFilter, operationFilter);
        if (response != null && response.size() > 0) {
            this.logger.debug((Object)"Rule found");
            return response.get(0);
        }
        this.logger.debug((Object)"Rule not found");
        return null;
    }

    private PolicyBean findPolicy(String role, String resource, String operation) {
        List<PolicyBean> pBeans;
        this.logger.debug((Object)"Finding policy ");
        role = "urn:d4science:roles:role-values:" + role;
        this.logger.debug((Object)("Role " + role));
        this.logger.debug((Object)("Resource " + resource));
        this.logger.debug((Object)("Operation " + operation));
        PolicySetType[] policySetList = new ArgusPolicyManagementClient(this.papUrl, this.credential).listPolicySets();
        List<PolicySetBean> policySets = this.findPolicySetsFromResource(policySetList, resource);
        if (policySets != null && policySets.size() > 0 && (pBeans = this.findPoliciesFromOperationAndRole(this.getPolicyIds(policySets), role, resource, operation)).size() > 0) {
            return pBeans.get(0);
        }
        return null;
    }

    private List<PolicySetBean> findPolicySetsFromResource(PolicySetType[] policySetList, String resourceFilter) {
        if (resourceFilter == null) {
            this.logger.debug((Object)"Resource filter disabled");
        }
        ArrayList<PolicySetBean> response = new ArrayList<PolicySetBean>();
        if (policySetList != null) {
            for (PolicySetType pst : policySetList) {
                TargetType tt = pst.getTarget();
                if (tt == null || tt.getResources() == null) continue;
                try {
                    IdReferenceType[] policyIdReference;
                    String foundResource = tt.getResources().getResource(0).getResourceMatch(0).getAttributeValue().get_any()[0].getAsString();
                    this.logger.debug((Object)("Resource found = " + foundResource));
                    if (resourceFilter != null && (foundResource == null || !foundResource.equals(resourceFilter)) || (policyIdReference = pst.getPolicyIdReference()) == null) continue;
                    PolicySetBean bean = new PolicySetBean();
                    bean.setId(pst.getPolicySetId());
                    bean.setResource(foundResource);
                    for (IdReferenceType idrT : policyIdReference) {
                        String policyId = idrT.get_value();
                        this.logger.debug((Object)("Policy Id reference " + policyId));
                        bean.addPolicyId(policyId);
                    }
                    response.add(bean);
                }
                catch (Exception e) {
                    this.logger.warn((Object)"Unable to find a resource ", (Throwable)e);
                }
            }
        }
        return response;
    }

    private Set<String> getPolicyIds(List<PolicySetBean> policySetList) {
        this.logger.debug((Object)"Finding policy ids");
        HashSet<String> response = new HashSet<String>();
        for (PolicySetBean bean : policySetList) {
            List<String> ids = bean.getPolicyIdReference();
            response.addAll(ids);
        }
        this.logger.debug((Object)"Policy ids found");
        return response;
    }

    private Set<String> getPolicyIds(PolicySetBean policySet) {
        this.logger.debug((Object)"Finding policy ids");
        HashSet<String> response = new HashSet<String>();
        List<String> ids = policySet.getPolicyIdReference();
        response.addAll(ids);
        this.logger.debug((Object)"Policy ids found");
        return response;
    }

    private List<PolicyBean> findPoliciesFromOperationAndRole(Set<String> policyIds, String roleFilter, String resource, String operationFilter) {
        this.logger.debug((Object)"Finding the policies");
        if (operationFilter == null) {
            this.logger.debug((Object)"Operation filter disabled");
        }
        ArrayList<PolicyBean> response = new ArrayList<PolicyBean>();
        for (String policyId : policyIds) {
            PolicyType pt = new ArgusPolicyManagementClient(this.papUrl, this.credential).getPolicy(policyId);
            TargetType tt = pt.getTarget();
            if (tt == null || tt.getActions() == null) continue;
            try {
                String foundAction = tt.getActions().getAction(0).getActionMatch(0).getAttributeValue().get_any()[0].getAsString();
                this.logger.debug((Object)("Action found = " + foundAction));
                if (operationFilter != null && (foundAction == null || !foundAction.equals(operationFilter))) continue;
                this.logger.debug((Object)"Action found");
                this.findPoliciesFromRole(response, pt.getRule(), roleFilter, resource, foundAction, pt);
            }
            catch (Exception e) {
                this.logger.warn((Object)"Unable to find a resource ", (Throwable)e);
            }
        }
        return response;
    }

    private List<PolicySetBean> findPolicyTypesFromOperation(List<PolicySetBean> policyIds, String resource, String operation) {
        this.logger.debug((Object)"Finding the policies");
        ArrayList<PolicySetBean> response = new ArrayList<PolicySetBean>();
        for (PolicySetBean policySetBean : policyIds) {
            List<String> policyReferences = policySetBean.getPolicyIdReference();
            PolicySetBean responseSetBean = new PolicySetBean();
            responseSetBean.setId(policySetBean.getId());
            for (String policyId : policyReferences) {
                PolicyType pt = new ArgusPolicyManagementClient(this.papUrl, this.credential).getPolicy(policyId);
                TargetType tt = pt.getTarget();
                if (tt != null && tt.getActions() != null) {
                    try {
                        String foundAction = tt.getActions().getAction(0).getActionMatch(0).getAttributeValue().get_any()[0].getAsString();
                        this.logger.debug((Object)("Action found = " + foundAction));
                        if (foundAction != null && foundAction.equals(operation)) {
                            responseSetBean.addPolicyId(policyId);
                        }
                    }
                    catch (Exception e) {
                        this.logger.warn((Object)"Unable to find a resource ", (Throwable)e);
                    }
                }
                response.add(responseSetBean);
            }
        }
        return response;
    }

    private void findPoliciesFromRole(List<PolicyBean> policyBeans, RuleType[] rules, String roleFilter, String resource, String operation, PolicyType policyReference) {
        if (roleFilter == null) {
            this.logger.debug((Object)"Role Filter disabled");
        }
        if (rules != null) {
            for (RuleType rule : rules) {
                TargetType tt = rule.getTarget();
                if (tt == null || tt.getSubjects() == null) continue;
                try {
                    String foundSubject = tt.getSubjects().getSubject(0).getSubjectMatch(0).getAttributeValue().get_any()[0].getAsString();
                    this.logger.debug((Object)("Subject found = " + foundSubject));
                    if (roleFilter != null && (foundSubject == null || !foundSubject.equals(roleFilter))) continue;
                    this.logger.debug((Object)"Rule match");
                    this.logger.debug((Object)"Subject found");
                    PolicyBean bean = new PolicyBean();
                    if (foundSubject != null && foundSubject.startsWith("urn:d4science:roles:role-values:")) {
                        foundSubject = foundSubject.substring("urn:d4science:roles:role-values:".length());
                    }
                    bean.setRole(foundSubject);
                    bean.setResource(resource);
                    bean.setOperation(operation);
                    bean.setPolicyReference(policyReference);
                    bean.setRuleReference(rule);
                    policyBeans.add(bean);
                }
                catch (Exception e) {
                    this.logger.warn((Object)"Unable to find a resource ", (Throwable)e);
                }
            }
        }
    }

    private boolean internalUpdateRule(PolicyBean policy, boolean permitted) {
        this.logger.debug((Object)"Updating rule");
        boolean response = false;
        if (policy != null) {
            this.logger.debug((Object)"Policy reference found");
            if (permitted == policy.isPermit()) {
                this.logger.debug((Object)policy.isPermit());
                this.logger.debug((Object)"Rule altready updated, nothing to do");
                response = true;
            } else {
                this.logger.debug((Object)"Finding references");
                PolicyType pt = policy.getPolicyReference();
                RuleType rt = policy.getRuleReference();
                if (permitted) {
                    rt.setEffect(EffectType.Permit);
                } else {
                    rt.setEffect(EffectType.Deny);
                }
                this.logger.debug((Object)"Updating permissions");
                this.logger.debug((Object)"Updating Argus");
                response = new ArgusPolicyManagementClient(this.papUrl, this.credential).updatePolicy(pt);
                this.logger.debug((Object)("Operation completed with result " + response));
            }
        }
        return response;
    }

    public static void main(String[] args) throws Exception {
        ArgusRuleManager service = new ArgusRuleManager("https://grid16.4dsoft.hu:8443/pap/services", null);
        System.out.println("Rule manager ok");
        List<RuleBean> rules = service.listRules();
        for (RuleBean r : rules) {
            System.out.println("Subject " + r.getSubject());
            System.out.println("Operation " + r.getOperation());
            System.out.println("Resource " + r.getResource());
            System.out.println("Permit " + r.isPermit());
        }
    }
}

