/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vomagement.policymanagement.impl;

import authz.glite.org.wsdl.pap.services.highlevel_policy_management.HighLevelPolicyManagementServicePortType;
import authz.glite.org.wsdl.pap.services.highlevel_policy_management.service.HighLevelPolicyManagementServiceLocator;
import authz.glite.org.wsdl.pap.services.xacml_policy_management.XACMLPolicyManagementServicePortType;
import authz.glite.org.wsdl.pap.services.xacml_policy_management.service.XACMLPolicyManagementServiceLocator;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.rpc.Stub;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vomagement.policymanagement.PolicyManagementClient;
import org.glite.authz.pap.services.AddRule;
import org.glite.authz.pap.services.AddRuleResponse;
import org.glite.authz.pap.services.Ban;
import org.glite.authz.pap.services.BanResponse;
import org.glite.authz.pap.services.EraseRepository;
import org.glite.authz.pap.services.GetPolicy;
import org.glite.authz.pap.services.ListPolicies;
import org.glite.authz.pap.services.ListPoliciesResponse;
import org.glite.authz.pap.services.ListPolicySets;
import org.glite.authz.pap.services.ListPolicySetsResponse;
import org.glite.authz.pap.services.Purge;
import org.glite.authz.pap.services.RemovePolicy;
import org.glite.authz.pap.services.RemovePolicyResponse;
import org.glite.authz.pap.services.StringList;
import org.glite.authz.pap.services.Unban;
import org.glite.authz.pap.services.UnbanResponse;
import org.glite.authz.pap.services.UnbanResult;
import org.glite.authz.pap.services.UpdatePolicy;
import org.glite.authz.pap.services.UpdatePolicyResponse;
import org.glite.authz.pap.services.UpdatePolicySet;
import org.glite.authz.pap.services.UpdatePolicySetResponse;
import org.globus.wsrf.impl.security.authentication.Constants;
import org.ietf.jgss.GSSCredential;
import os.schema.policy._0._2.xacml.tc.names.oasis.GetPolicyReturn;
import os.schema.policy._0._2.xacml.tc.names.oasis.PolicySetType;
import os.schema.policy._0._2.xacml.tc.names.oasis.PolicyType;

public class ArgusPolicyManagementClient
implements PolicyManagementClient {
    private GCUBELog logger = new GCUBELog((Object)this);
    private final String OBLIGATION_SCOPE_RESUORCE = "resource";
    private final String SUBJECT_ID = "subject";
    private final String HIGH_LEVEL_SERVICE = "HighLevelPolicyManagementService";
    private final String XACML_SERVICE = "XACMLPolicyManagementService";
    private HighLevelPolicyManagementServicePortType hlPolicyManagementService;
    private XACMLPolicyManagementServicePortType xacmlPolicyManagementService;
    private static final String ALIAS_DEFAULT = "default";

    public ArgusPolicyManagementClient(String papServiceURL, GSSCredential credentials) {
        try {
            this.hlPolicyManagementService = this.initHighLevelService(papServiceURL, credentials);
            this.xacmlPolicyManagementService = this.initXacmlService(papServiceURL, credentials);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private HighLevelPolicyManagementServicePortType initHighLevelService(String papUrl, GSSCredential credentials) throws Exception {
        this.logger.debug((Object)"Initializing High level policy management service...");
        String finalUrl = papUrl + "/" + "HighLevelPolicyManagementService";
        URL endpoint = new URL(finalUrl);
        this.logger.debug((Object)("Url = " + finalUrl));
        HighLevelPolicyManagementServicePortType response = new HighLevelPolicyManagementServiceLocator().getHighLevelPolicyManagementServicePortTypePort(endpoint);
        if (credentials != null) {
            ((Stub)response)._setProperty("org.globus.gsi.credentials", (Object)credentials);
            ((Stub)response)._setProperty("org.globus.security.transport.type", (Object)Constants.SIGNATURE);
            ((Stub)response)._setProperty("org.globus.security.transport.type", (Object)Constants.ENCRYPTION);
        }
        this.logger.debug((Object)"High level policy management service initialized");
        return response;
    }

    private XACMLPolicyManagementServicePortType initXacmlService(String papUrl, GSSCredential credentials) throws Exception {
        this.logger.debug((Object)"Initializing XACML policy management service...");
        String finalUrl = papUrl + "/" + "XACMLPolicyManagementService";
        URL endpoint = new URL(finalUrl);
        this.logger.debug((Object)("Url = " + finalUrl));
        XACMLPolicyManagementServicePortType response = new XACMLPolicyManagementServiceLocator().getXACMLPolicyManagementServicePortTypePort(endpoint);
        if (credentials != null) {
            ((Stub)response)._setProperty("org.globus.gsi.credentials", (Object)credentials);
            ((Stub)response)._setProperty("org.globus.security.transport.type", (Object)Constants.SIGNATURE);
            ((Stub)response)._setProperty("org.globus.security.transport.type", (Object)Constants.ENCRYPTION);
        }
        this.logger.debug((Object)"High level policy management service initialized");
        return response;
    }

    @Override
    public String addRule(String role, String operation, String resource, boolean permit) {
        this.logger.debug((Object)"Adding policy...");
        this.logger.debug((Object)("role " + role));
        this.logger.debug((Object)("Operation... " + operation));
        this.logger.debug((Object)("Resource " + resource));
        String response = null;
        try {
            AddRule rule = new AddRule();
            rule.setAlias(ALIAS_DEFAULT);
            rule.setIsPermit(true);
            StringList list = new StringList();
            list.setPolicyId(new String[]{this.generateRoleIdString(role)});
            rule.setAttributeList(list);
            rule.setResourceValue(resource);
            rule.setIsPermit(permit);
            rule.setActionValue(operation);
            rule.setObligationScope("resource");
            rule.setMoveAfter(false);
            AddRuleResponse r = this.hlPolicyManagementService.addRule(rule);
            if (r != null && r.getAddRuleReturn() != null) {
                response = r.getAddRuleReturn();
                this.logger.debug((Object)("Policy id " + response));
            } else {
                this.logger.error((Object)"Unable to add the new policy");
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to add policy ", (Throwable)e);
        }
        return response;
    }

    public String ban(String role, String operation, String resource) {
        String response = null;
        try {
            Ban ban = new Ban();
            ban.setAlias(ALIAS_DEFAULT);
            ban.setId("subject");
            StringBuilder roleStringBuilder = new StringBuilder("subject");
            roleStringBuilder.append("=").append("urn:d4science:roles:role-values:").append(role);
            ban.setValue(this.generateRoleString(role));
            ban.setAction(operation);
            ban.setResource(resource);
            ban.setIsPublic(true);
            BanResponse banResponse = this.hlPolicyManagementService.ban(ban);
            if (banResponse != null && banResponse.getBanReturn() != null) {
                response = banResponse.getBanReturn();
                this.logger.debug((Object)("Policy id " + response));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }

    public UnbanResult unban(String role, String operation, String resource) {
        UnbanResult response = null;
        try {
            Unban unban = new Unban();
            unban.setAlias(ALIAS_DEFAULT);
            unban.setId("subject");
            StringBuilder roleStringBuilder = new StringBuilder("subject");
            roleStringBuilder.append("=").append("urn:d4science:roles:role-values:").append(role);
            unban.setValue(this.generateRoleString(role));
            unban.setAction(operation);
            unban.setResource(resource);
            UnbanResponse banResponse = this.hlPolicyManagementService.unban(unban);
            if (banResponse != null && banResponse.getUnbanReturn() != null) {
                response = banResponse.getUnbanReturn();
                this.logger.debug((Object)("Policy id " + response));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error in unbanning process ", (Throwable)e);
        }
        return response;
    }

    @Override
    public PolicySetType[] listPolicySets() {
        this.logger.debug((Object)"Getting the policy sets list");
        PolicySetType[] response = null;
        try {
            this.logger.debug((Object)"Sending request");
            ListPolicySets policies = new ListPolicySets();
            policies.setAlias(ALIAS_DEFAULT);
            ListPolicySetsResponse listPolicySetsResponse = this.xacmlPolicyManagementService.listPolicySets(policies);
            response = listPolicySetsResponse.getListPolicySetsReturn().getPolicySet();
            this.logger.debug((Object)"list received");
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to load policy sets list", (Throwable)e);
        }
        return response;
    }

    @Override
    public PolicyType getPolicy(String policyId) {
        this.logger.debug((Object)"Getting the policy");
        PolicyType response = null;
        try {
            this.logger.debug((Object)"Sending request");
            GetPolicy getPolicy = new GetPolicy();
            getPolicy.setAlias(ALIAS_DEFAULT);
            getPolicy.setPolicyId(policyId);
            GetPolicyReturn getPolicyReturn = this.xacmlPolicyManagementService.getPolicy(getPolicy);
            response = getPolicyReturn.getPolicy();
            this.logger.debug((Object)"list received");
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to load policy " + policyId), (Throwable)e);
        }
        return response;
    }

    @Override
    public boolean removePolicy(String policyId) {
        this.logger.debug((Object)"Removing the policy");
        Boolean response = null;
        try {
            this.logger.debug((Object)"Sending request");
            RemovePolicy removePolicy = new RemovePolicy();
            removePolicy.setAlias(ALIAS_DEFAULT);
            removePolicy.setPolicyId(policyId);
            RemovePolicyResponse removePolicyResponse = this.xacmlPolicyManagementService.removePolicy(removePolicy);
            response = removePolicyResponse.getRemovePolicyReturn();
            this.logger.debug((Object)"policy removed");
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to remove the policy " + policyId), (Throwable)e);
        }
        return response;
    }

    @Override
    public PolicyType[] listPolicies() {
        this.logger.debug((Object)"Getting the policy list");
        PolicyType[] response = null;
        try {
            this.logger.debug((Object)"Sending request");
            ListPolicies policies = new ListPolicies();
            policies.setAlias(ALIAS_DEFAULT);
            ListPoliciesResponse listPolicyResponse = this.xacmlPolicyManagementService.listPolicies(policies);
            response = listPolicyResponse.getListPoliciesReturn().getPolicy();
            this.logger.debug((Object)"list received");
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to load policy list", (Throwable)e);
        }
        return response;
    }

    @Override
    public boolean updatePolicySet(PolicySetType policySet) {
        this.logger.debug((Object)("Updating policy set " + policySet.getPolicySetId()));
        boolean returnValue = false;
        try {
            UpdatePolicySet updatePolicySet = new UpdatePolicySet();
            updatePolicySet.setAlias(ALIAS_DEFAULT);
            updatePolicySet.setPolicySet(policySet);
            UpdatePolicySetResponse response = this.xacmlPolicyManagementService.updatePolicySet(updatePolicySet);
            returnValue = response.getUpdatePolicySetReturn();
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable update policy set", (Throwable)e);
        }
        return returnValue;
    }

    @Override
    public boolean updatePolicy(PolicyType policy) {
        this.logger.debug((Object)("Updating policy " + policy.getPolicyId()));
        boolean returnValue = false;
        try {
            UpdatePolicy updatePolicy = new UpdatePolicy();
            updatePolicy.setAlias(ALIAS_DEFAULT);
            updatePolicy.setVersion(policy.getVersion());
            updatePolicy.setPolicy(policy);
            UpdatePolicyResponse response = this.xacmlPolicyManagementService.updatePolicy(updatePolicy);
            returnValue = response.getUpdatePolicyReturn();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)"Unable update policy", (Throwable)e);
        }
        return returnValue;
    }

    @Override
    public boolean purge(boolean purgeUnreferencedPolicies, boolean purgeEmptyPolicies, boolean purgeUnreferencedPolicySets, boolean purgeEmptyPolicySets) {
        this.logger.debug((Object)"Purge policies");
        try {
            Purge purge = new Purge();
            purge.setAlias(ALIAS_DEFAULT);
            purge.setPurgeEmptyPolicies(purgeEmptyPolicySets);
            purge.setPurgeUnreferencedPolicies(purgeUnreferencedPolicies);
            purge.setPurgeEmptyPolicies(purgeEmptyPolicies);
            purge.setPurgeUnreferencedPolicies(purgeUnreferencedPolicies);
            this.hlPolicyManagementService.purge(purge);
            this.logger.debug((Object)"Operation completed");
            return true;
        }
        catch (RemoteException e) {
            this.logger.error((Object)"Operation failed", (Throwable)e);
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean eraseRepository() {
        this.logger.debug((Object)"Erase repository");
        try {
            EraseRepository eraseRepository = new EraseRepository();
            eraseRepository.setAlias(ALIAS_DEFAULT);
            this.hlPolicyManagementService.eraseRepository(eraseRepository);
            this.logger.debug((Object)"Operation completed");
            return true;
        }
        catch (Exception e) {
            this.logger.error((Object)"Operation failed", (Throwable)e);
            return false;
        }
    }

    private String generateRoleIdString(String role) {
        StringBuilder roleStringBuilder = new StringBuilder("subject");
        roleStringBuilder.append("=").append("urn:d4science:roles:role-values:").append(role);
        return roleStringBuilder.toString();
    }

    private String generateRoleString(String role) {
        StringBuilder roleStringBuilder = new StringBuilder("urn:d4science:roles:role-values:");
        roleStringBuilder.append(role);
        return roleStringBuilder.toString();
    }

    public static void main(String[] args) throws Exception {
        ArgusPolicyManagementClient client = new ArgusPolicyManagementClient("https://grid16.4dsoft.hu:8150/pap/services", null);
        System.out.println(client.purge(true, true, true, true));
    }
}

