/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.authorisation.control.utils;

import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Stub;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.gcube.common.core.security.context.SecurityContextFactory;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vomanagement.security.authorisation.control.utils.bean.IdentityBean;
import org.gcube.vomanagement.usermanagement.ws.LiferaySOAPIdentityProviderPortType;
import org.gcube.vomanagement.usermanagement.ws.ListGroupsAndRolesByUserCustomField;
import org.gcube.vomanagement.usermanagement.ws.ListGroupsAndRolesByUserCustomFieldResponse;
import org.gcube.vomanagement.usermanagement.ws.RoleModel;
import org.gcube.vomanagement.usermanagement.ws.UserModel;
import org.gcube.vomanagement.usermanagement.ws.UserModelRoleListCoupleWrapper;
import org.gcube.vomanagement.usermanagement.ws.service.LiferaySOAPIdentityProviderServiceAddressingLocator;
import org.globus.wsrf.impl.security.authentication.Constants;

public class IdentityProviderManager {
    private LiferaySOAPIdentityProviderPortType service;
    private GCUBELog logger = new GCUBELog((Object)this);
    private static final String DISTINGUISHED_NAME = "dn";
    private String url;

    public IdentityProviderManager(String identityProviderUrl) throws URI.MalformedURIException, ServiceException, MalformedURLException {
        this.logger.debug((Object)("Initializing the service " + identityProviderUrl));
        EndpointReferenceType endpoint = new EndpointReferenceType();
        endpoint.setAddress(new AttributedURI(identityProviderUrl));
        this.service = new LiferaySOAPIdentityProviderServiceAddressingLocator().getLiferaySOAPIdentityProviderPortTypePort(endpoint);
        this.url = identityProviderUrl;
        if (new URL(this.url).getProtocol().equalsIgnoreCase("https")) {
            this.setSecurity((Stub)this.service);
        }
        this.logger.debug((Object)"Service initialized");
    }

    public IdentityBean getIdentity(String distinguishedName) throws Exception {
        UserModel userModel;
        ListGroupsAndRolesByUserCustomField dataDn = new ListGroupsAndRolesByUserCustomField();
        dataDn.setArg0(DISTINGUISHED_NAME);
        dataDn.setArg1(distinguishedName);
        ListGroupsAndRolesByUserCustomFieldResponse wsResponse = this.service.listGroupsAndRolesByUserCustomField(dataDn);
        UserModelRoleListCoupleWrapper[] userModelRoleListCoupleWrapperList = wsResponse.get_return();
        IdentityBean response = null;
        if (userModelRoleListCoupleWrapperList != null && userModelRoleListCoupleWrapperList.length > 0 && (userModel = userModelRoleListCoupleWrapperList[0].getUserModel()) != null) {
            response = new IdentityBean();
            response.setUserId(userModel.getScreenName());
            RoleModel[] roleModels = userModelRoleListCoupleWrapperList[0].getRoleModels();
            if (roleModels != null) {
                for (RoleModel rm : roleModels) {
                    response.addRole(rm.getCompleteName());
                }
            }
        }
        return response;
    }

    private void setSecurity(Stub stub) {
        this.logger.debug((Object)"Setfing security credentials");
        this.logger.debug((Object)"Secure protocol called: inserting credentials");
        stub._setProperty("org.globus.gsi.credentials", (Object)SecurityContextFactory.getInstance().getSecurityContext().getDefaultCredentials());
        stub._setProperty("org.globus.security.transport.type", (Object)Constants.SIGNATURE);
        stub._setProperty("org.globus.security.transport.type", (Object)Constants.ENCRYPTION);
        this.logger.debug((Object)"Secure protocol called: credentials inserted");
    }

    public String getIdentityServiceUrl() {
        return this.url;
    }
}

