/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.configuration;

import java.rmi.Remote;
import java.util.Collections;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import org.apache.axis.MessageContext;
import org.apache.axis.client.Stub;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.GCUBEServiceSecurityManager;
import org.gcube.common.core.security.SecurityCredentials;
import org.gcube.common.core.security.context.SecurityContextFactory;
import org.gcube.common.core.utils.events.GCUBEEvent;
import org.gcube.common.core.utils.events.GCUBETopic;
import org.gcube.common.vomanagement.security.authorisation.core.impl.SAMLSecurityCredentials;
import org.gcube.common.vomanagement.security.authorisation.core.saml.SamlAssertionTask;
import org.gcube.common.vomanagement.security.configuration.GCUBEServiceSecurityConfigurationManager;
import org.gcube.common.vomanagement.security.configuration.SAMLAssertionConsumer;
import org.globus.wsrf.impl.security.authentication.Constants;
import org.globus.wsrf.impl.security.authorization.HostAuthorization;
import org.opensaml.SAMLAssertion;

public class GCUBESamlAssertionServiceSecurityManager
extends GCUBEServiceSecurityConfigurationManager
implements SAMLAssertionConsumer {
    protected Map<Thread, SAMLAssertion> callCredentials = Collections.synchronizedMap(new WeakHashMap());
    private Timer assertionRenewalTimer;

    @Override
    public void initialise(GCUBEServiceContext ctxt) throws Exception {
        this.logger.debug((Object)"Initialising...");
        this.context = ctxt;
        this.initialiseCredentialTask();
        this.producer.notify((GCUBETopic)GCUBEServiceSecurityManager.LifetimeTopic.POLICYUPDATE, new GCUBEEvent[]{new GCUBEServiceSecurityManager.LifetimeEvent()});
        this.logger.debug((Object)"Intialisation completed");
    }

    public void useCredentials(SecurityCredentials credentials) throws Exception {
        this.useCredentials(Thread.currentThread(), credentials);
    }

    public void useCredentials(Thread thread, SecurityCredentials ... credentials) throws Exception {
        if (!this.isSecurityEnabled()) {
            return;
        }
        if (credentials.length == 0) {
            credentials = new SecurityCredentials[]{this.getCredentials()};
        }
        try {
            SAMLAssertion assertionCredentials = (SAMLAssertion)credentials[0].getCredentialsAsObject();
            this.logger.debug((Object)("Using credentials of the assertion (" + assertionCredentials.getAssertionID() + ") in thread " + thread.getName() + "(" + thread.getId() + ")"));
            this.callCredentials.put(thread, assertionCredentials);
        }
        catch (ClassCastException e) {
            this.logger.error((Object)("Invalid credentials: expected SAML Assertion Credentials and found " + credentials[0].getCredentialsAsObject().getClass()));
        }
    }

    public SecurityCredentials getCredentials() {
        SAMLAssertion internalCred = this.callCredentials.get(Thread.currentThread());
        if (internalCred != null) {
            this.logger.debug((Object)"Credentials found for the current thread");
            return new SAMLSecurityCredentials(internalCred);
        }
        if (this.propagateCallerCredentials) {
            this.logger.debug((Object)"Credentials not set, using caller credentials");
            try {
                return this.getCallerCredentials();
            }
            catch (Exception e) {
                this.logger.error((Object)"Unable to find caller credentials, probably the credentials are not available, disable the credential propagation in the service configuration", (Throwable)e);
                this.logger.error((Object)"Trying to use service credentials");
            }
        }
        this.logger.debug((Object)"Using service credentials");
        try {
            return this.getServiceCredentials();
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to find service credentials", (Throwable)e);
            this.logger.error((Object)"No authorization credentials will be used");
            return null;
        }
    }

    public void setSecurity(Remote s, GCUBESecurityManager.AuthMode e, GCUBESecurityManager.DelegationMode d) throws Exception {
        this.logger.debug((Object)("setting security parameters for service " + this.context.getService().getServiceName()));
        if (this.isSecurityEnabled()) {
            Stub stub = (Stub)s;
            stub._setProperty("org.globus.gsi.credentials", (Object)SecurityContextFactory.getInstance().getSecurityContext().getDefaultCredentials());
            SAMLSecurityCredentials credentials = (SAMLSecurityCredentials)this.getCredentials();
            if (credentials != null && credentials.getAssertion() != null) {
                this.logger.debug((Object)"setting SAML assertion");
                stub._setProperty("org.globus.security.authorization.samlAssertion", (Object)credentials.getAssertion());
                this.logger.debug((Object)"SAML assertion set");
            } else {
                this.logger.error((Object)"credentials or assertion not found");
            }
            String authMethodString = null;
            if (this.authMethod == GCUBESecurityManager.AuthMethod.GSI_CONV) {
                this.logger.debug((Object)"GSI Secure conversation");
                authMethodString = "org.globus.security.secConv.msg.type";
                this.logger.debug((Object)"Setting delegation...");
                this.logger.debug((Object)("delegation " + e));
                switch (d) {
                    case FULL: {
                        stub._setProperty("org.globus.security.authorization", (Object)HostAuthorization.getInstance());
                        stub._setProperty("org.globus.gsi.mode", (Object)"gsifull");
                        break;
                    }
                    case LIMITED: {
                        stub._setProperty("org.globus.security.authorization", (Object)HostAuthorization.getInstance());
                        stub._setProperty("org.globus.gsi.mode", (Object)"gsilimited");
                    }
                }
            } else {
                this.logger.debug((Object)"GSI Secure transport");
                authMethodString = "org.globus.security.transport.type";
            }
            switch (e) {
                case INTEGRITY: {
                    stub._setProperty(authMethodString, (Object)Constants.SIGNATURE);
                    break;
                }
                case PRIVACY: {
                    stub._setProperty(authMethodString, (Object)Constants.ENCRYPTION);
                    break;
                }
                case BOTH: {
                    stub._setProperty(authMethodString, (Object)Constants.SIGNATURE);
                    stub._setProperty(authMethodString, (Object)Constants.ENCRYPTION);
                }
            }
            this.logger.debug((Object)("Setting authentication GSI sec transport= " + e.name() + " on " + stub.getClass().getSimpleName()));
        } else {
            this.logger.debug((Object)"Security not enabled, nothing to do");
        }
    }

    public SecurityCredentials getCallerCredentials() throws Exception {
        return new SAMLSecurityCredentials(this.getCallerSAMLAssertion());
    }

    public boolean needServiceCredentials() {
        return true;
    }

    private SAMLAssertion getCallerSAMLAssertion() {
        this.logger.debug((Object)"getting caller SAML assertion...");
        MessageContext msgCtx = MessageContext.getCurrentContext();
        SAMLAssertion assertion = (SAMLAssertion)msgCtx.getProperty("org.globus.security.authorization.samlAssertion");
        if (assertion == null) {
            this.logger.warn((Object)"The SAML Assertion is null!");
        } else {
            this.logger.debug((Object)("SAML assertion = " + assertion.toString()));
        }
        return assertion;
    }

    @Override
    public synchronized void setSAMLAssertion(SAMLAssertion assertion) {
        if (assertion == null) {
            this.logger.trace((Object)"setting SAML credentials to null");
            this.serviceCredentials = null;
        } else {
            this.logger.trace((Object)"Adding fresh SAML assertion");
            this.serviceCredentials = new SAMLSecurityCredentials(assertion);
        }
        this.producer.notify((GCUBETopic)GCUBEServiceSecurityManager.LifetimeTopic.CREDENTIALUPDATE, new GCUBEEvent[]{new GCUBEServiceSecurityManager.LifetimeEvent()});
    }

    private void initialiseCredentialTask() throws Exception {
        if (!this.isSecurityEnabled()) {
            this.logger.info((Object)("no credentials are needed for service " + this.context.getServiceClass() + ":" + this.context.getName()));
            this.setSAMLAssertion(null);
        } else {
            this.logger.info((Object)("subscribing for credentials for service " + this.context.getServiceClass() + ":" + this.context.getName()));
            SamlAssertionTask renewalTask = new SamlAssertionTask(this.context.getService(), this);
            this.assertionRenewalTimer = new Timer(renewalTask.getName());
            this.assertionRenewalTimer.schedule((TimerTask)renewalTask, 0L, renewalTask.getTimerPeriod());
        }
    }
}

