/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.authorisation.core.saml;

import java.util.TimerTask;
import org.gcube.common.core.resources.GCUBEService;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vomanagement.security.authorisation.utils.AssertionGenerator;
import org.gcube.common.vomanagement.security.configuration.SAMLAssertionConsumer;
import org.opensaml.SAMLAssertion;

public class SamlAssertionTask
extends TimerTask {
    private GCUBELog logger;
    private String serviceString;
    private String serviceID;
    private SAMLAssertion assertion;
    private SAMLAssertionConsumer consumer;
    private int lifetime;
    private final String TASK_NAME_PREFIX = "ASSERTION_RENEWAL";
    private String name;

    public SamlAssertionTask(GCUBEService service, SAMLAssertionConsumer consumer, int lifetime) {
        this.logger = new GCUBELog(this.getClass());
        this.logger.debug((Object)"initialising assertion credential renewer");
        String serviceName = service.getServiceName();
        String serviceClass = service.getServiceClass();
        this.logger.debug((Object)("for " + serviceClass + " " + serviceName));
        this.serviceID = service.getID();
        this.logger.debug((Object)("service id = " + this.serviceID));
        StringBuilder builder = new StringBuilder(serviceClass);
        builder.append('.').append(serviceName);
        this.init(builder.toString(), serviceName, consumer, lifetime);
    }

    public SamlAssertionTask(String identityString, String taskName, SAMLAssertionConsumer consumer) {
        this.init(identityString, taskName, consumer, -1);
    }

    public SamlAssertionTask(String identityString, String taskName, SAMLAssertionConsumer consumer, int lifetime) {
        this.init(identityString, taskName, consumer, lifetime);
    }

    private void init(String identityString, String taskName, SAMLAssertionConsumer consumer, int lifetime) {
        this.logger.debug((Object)"Init");
        this.consumer = consumer;
        this.serviceString = identityString;
        this.lifetime = lifetime <= 0 ? -1 : lifetime;
        this.name = "ASSERTION_RENEWAL_" + taskName;
        this.logger.debug((Object)("lifetime = " + this.lifetime));
        this.logger.debug((Object)("Service string = " + this.serviceString));
    }

    public SamlAssertionTask(GCUBEService service, SAMLAssertionConsumer consumer) {
        this(service, consumer, -1);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void run() {
        try {
            AssertionGenerator samlAssertionGenerator = new AssertionGenerator();
            if (this.lifetime != -1) {
                samlAssertionGenerator.setLifetimeSec(this.lifetime);
            }
            samlAssertionGenerator.setUserId(this.serviceString);
            samlAssertionGenerator.addRole(this.serviceString);
            this.assertion = samlAssertionGenerator.generateSignedAssertion();
            this.logger.debug((Object)("assertion = " + this.assertion.toString()));
            this.consumer.setSAMLAssertion(this.assertion);
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to generate the service identity assertion", (Throwable)e);
        }
    }

    public SAMLAssertion getAssertion() {
        return this.assertion;
    }

    public long getTimerPeriod() {
        long baseTimer = this.lifetime == -1 ? 28800L : (long)this.lifetime;
        this.logger.debug((Object)("Base timer = " + baseTimer));
        return baseTimer / 2L * 1000L;
    }
}

