/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.authorisation.impl.simple;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.contexts.service.Consumer;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.handlers.GCUBEScheduledHandler;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vomanagement.security.authorisation.impl.simple.GHNCredentials;

public class GCUBEGenericResourceAuthZPolicyPIP {
    public static final String TRUSTED_PORTAL_CREDENTIALS = "TrustedPortalCredentials";
    public static final String TRUSTED_SERVICE_POLICY = "TrustedServicePolicy";
    public static final String POLICY_SECONDARY_TYPE = "AuthZPolicy";
    public static final String PORTAL_NAME = "PORTAL";
    public static final String SEPARATOR = "-&gt;";
    private static GCUBEGenericResourceAuthZPolicyPIP instance;
    private GCUBEServiceContext context;
    protected GCUBELog logger = new GCUBELog((Object)this);
    private static final String DN_PREFIX = "DN='";
    private static final String DN_SUFFIX = "'";
    private static final String CA_PREFIX = "CA='";
    private static final String CA_SUFFIX = "'";
    private static Map<GCUBEScope, Scheduler> schedulers;

    public static GCUBEGenericResourceAuthZPolicyPIP getInstance(GCUBEServiceContext context) throws Exception {
        if (instance == null) {
            instance = new GCUBEGenericResourceAuthZPolicyPIP(context);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GCUBEGenericResourceAuthZPolicyPIP(GCUBEServiceContext context) throws Exception {
        this.context = context;
        for (GCUBEScope scope : context.getInstance().getScopes().values()) {
            context.getLogger().trace((Object)("acquiring AuthZPolicy resources from IS for scope " + scope));
            Map<GCUBEScope, Scheduler> map = schedulers;
            synchronized (map) {
                Scheduler s = schedulers.get(scope);
                if (s == null) {
                    s = new Scheduler(scope);
                    s.run();
                    Scheduler scheduler = s;
                    synchronized (scheduler) {
                        ((Object)((Object)s)).wait();
                        if (s.getPolicyGenericResources() == null) {
                            throw new Exception("cannot acquire AuthZPolicy resources from IS for scope " + scope);
                        }
                    }
                    schedulers.put(scope, s);
                } else {
                    context.getLogger().trace((Object)("increasing sharing for GCUBEGenericResourceAuthZPolicyPIP in " + scope));
                    s.increaseSharing();
                }
                try {
                    context.subscribeLifetTime((Consumer)new RIMonitor(s), new GCUBEServiceContext.RILifetimeTopic[]{GCUBEServiceContext.RILifetimeTopic.FAILED});
                }
                catch (Exception e) {
                    context.getLogger().warn((Object)"could not subscribe GCUBEGenericResourceAuthZPolicyPIP to RI lifetime");
                }
            }
        }
    }

    public GCUBEServiceContext getContext() {
        return this.context;
    }

    public void setContext(GCUBEServiceContext context) {
        this.context = context;
    }

    public List<GHNCredentials> getPortalCredentials(GCUBEScope scope) {
        Scheduler s = schedulers.get(scope);
        List<GCUBEGenericResource> resources = s.getPolicyGenericResources();
        ArrayList<GHNCredentials> credList = new ArrayList<GHNCredentials>();
        for (GCUBEGenericResource resource : resources) {
            if (!TRUSTED_PORTAL_CREDENTIALS.equals(resource.getName())) continue;
            GHNCredentials creds = this.parseResource(resource);
            credList.add(creds);
        }
        return credList;
    }

    private GHNCredentials parseResource(GCUBEGenericResource resource) {
        String body = resource.getBody();
        String dn = this.extractNamefrom(body, DN_PREFIX, "'");
        String ca = this.extractNamefrom(body, CA_PREFIX, "'");
        return new GHNCredentials(dn, ca);
    }

    private String extractNamefrom(String body, String prefix, String suffix) {
        this.logger.trace((Object)("Extracting name from '" + body + "' with prefix " + prefix + " and suffix " + suffix));
        int beginIndex = body.indexOf(prefix) + prefix.length();
        int endIndex = body.indexOf(suffix, beginIndex);
        String extracted = body.substring(beginIndex, endIndex);
        this.logger.trace((Object)("Extracting name (" + beginIndex + "," + endIndex + ") returned: " + extracted));
        return extracted;
    }

    public Map<String, List<String>> getTrustedServicePolicies(GCUBEScope scope, String invokedService) {
        Scheduler s = schedulers.get(scope);
        List<GCUBEGenericResource> resources = s.getPolicyGenericResources();
        HashMap<String, List<String>> authorisedInvokersPerOperation = new HashMap<String, List<String>>();
        for (GCUBEGenericResource resource : resources) {
            if (!TRUSTED_SERVICE_POLICY.equals(resource.getName()) || !invokedService.equals(this.getInvokedServiceFrom(resource))) continue;
            String operation = this.getOperationFrom(resource);
            if (!authorisedInvokersPerOperation.containsKey(operation)) {
                authorisedInvokersPerOperation.put(operation, new ArrayList());
            }
            ((List)authorisedInvokersPerOperation.get(operation)).add(this.getInvokerFrom(resource));
        }
        return authorisedInvokersPerOperation;
    }

    private String getInvokerFrom(GCUBEGenericResource resource) {
        this.logger.trace((Object)("Getting invoker from resource body: " + resource.getBody()));
        String[] parts = resource.getBody().split(SEPARATOR);
        return parts[0].trim();
    }

    private String getOperationFrom(GCUBEGenericResource resource) {
        this.logger.trace((Object)("Getting operation from resource body: " + resource.getBody()));
        String[] parts = resource.getBody().split(SEPARATOR);
        return parts[1].trim();
    }

    private Object getInvokedServiceFrom(GCUBEGenericResource resource) {
        this.logger.trace((Object)("Getting invoked from resource body: " + resource.getBody()));
        String[] parts = resource.getBody().split(SEPARATOR);
        return parts[2].trim();
    }

    public List<String> getTrustedPortalPolicies(GCUBEScope scope, String invokedService) {
        Map<String, List<String>> policies = this.getTrustedServicePolicies(scope, invokedService);
        ArrayList<String> operations = new ArrayList<String>();
        for (String operation : policies.keySet()) {
            List<String> invokers = policies.get(operation);
            if (!invokers.contains(PORTAL_NAME)) continue;
            operations.add(operation);
        }
        return operations;
    }

    private List<GCUBEGenericResource> generateDummyResourceList() throws Exception {
        ArrayList<GCUBEGenericResource> res = new ArrayList<GCUBEGenericResource>();
        GCUBEGenericResource r1 = (GCUBEGenericResource)GHNContext.getImplementation(GCUBEGenericResource.class);
        r1.setID("1");
        r1.setSecondaryType(POLICY_SECONDARY_TYPE);
        r1.setName(TRUSTED_PORTAL_CREDENTIALS);
        r1.setBody("DN='/O=Grid/OU=GlobusTest/OU=simpleCA-gauss.eng.it/CN=grids05.eng.it',CA='/O=Grid/OU=GlobusTest/OU=simpleCA-gauss.eng.it/CN=Globus Simple CA'");
        res.add(r1);
        GCUBEGenericResource r2 = (GCUBEGenericResource)GHNContext.getImplementation(GCUBEGenericResource.class);
        r2.setID("1");
        r2.setSecondaryType(POLICY_SECONDARY_TYPE);
        r2.setName(TRUSTED_SERVICE_POLICY);
        r2.setBody("PORTAL-&gt;about-&gt;Samples:SampleService");
        res.add(r2);
        return res;
    }

    static {
        schedulers = new HashMap<GCUBEScope, Scheduler>();
    }

    private class Scheduler
    extends GCUBEScheduledHandler<GCUBEScope> {
        private long POLLING_INTERVAL;
        private static final int ATTEMPTS_AT_START = 3;
        private List<GCUBEGenericResource> resources;
        private short sharing;

        Scheduler(GCUBEScope s) {
            super(0L, GCUBEScheduledHandler.Mode.LAZY, new GCUBEHandler[0]);
            this.POLLING_INTERVAL = GHNContext.getContext().getTrustedGHNSynchInterval();
            this.sharing = 1;
            this.setScheduled(new QueryTask(s));
        }

        synchronized void increaseSharing() {
            this.sharing = (short)(this.sharing + 1);
        }

        synchronized void decreaseSharing() {
            this.sharing = (short)(this.sharing - 1);
            if (this.sharing == 0) {
                this.stop();
            }
        }

        synchronized List<GCUBEGenericResource> getPolicyGenericResources() {
            return this.resources;
        }

        private synchronized void setPolicyGenericResources(List<GCUBEGenericResource> resources) {
            this.resources = resources;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean repeat(Exception exception, int exceptionCount) {
            this.setInterval(this.POLLING_INTERVAL);
            GCUBEGenericResourceAuthZPolicyPIP.this.context.getLogger().info((Object)("TrustedGHNSynchInterval set to " + this.getInterval() / 1000L + " seconds"));
            if (exception == null) {
                Scheduler scheduler = this;
                synchronized (scheduler) {
                    ((Object)((Object)this)).notify();
                }
                this.exceptionCount = 0;
                return true;
            }
            if (this.resources == null && exceptionCount >= 3) {
                Scheduler scheduler = this;
                synchronized (scheduler) {
                    ((Object)((Object)this)).notify();
                }
                return false;
            }
            GCUBEGenericResourceAuthZPolicyPIP.this.context.getLogger().warn((Object)("could not refresh GCUBEGenericResourceAuthZPolicyPIP state (failure n." + this.exceptionCount + ")"), (Throwable)this.exception);
            return true;
        }

        private class QueryTask
        extends GCUBEHandler<GCUBEScope> {
            QueryTask(GCUBEScope s) {
                this.setHandled(s);
            }

            public void run() throws Exception {
                ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
                GCUBEGenericResourceQuery resourceQuery = (GCUBEGenericResourceQuery)client.getQuery(GCUBEGenericResourceQuery.class);
                resourceQuery.addGenericCondition("$result/Profile/SecondaryType/string() eq 'AuthZPolicy'");
                Scheduler.this.setPolicyGenericResources(client.execute((ISQuery)resourceQuery, (GCUBEScope)this.getHandled()));
            }
        }
    }

    private class RIMonitor
    extends Consumer {
        Scheduler scheduler;

        RIMonitor(Scheduler scheduler) {
            this.scheduler = scheduler;
        }

        protected synchronized void onRIFailed(GCUBEServiceContext.RILifetimeEvent event) throws Exception {
            this.scheduler.decreaseSharing();
        }
    }
}

