/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.authorisation.impl.simple;

import com.thoughtworks.xstream.XStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vomanagement.security.authorisation.control.impl.policies.GCUBEPolicy;
import org.gcube.common.vomanagement.security.authorisation.control.impl.policies.GCUBEPolicyEvaluationResponse;
import org.gcube.common.vomanagement.security.authorisation.core.PolicyEvaluationException;
import org.gcube.common.vomanagement.security.authorisation.core.PolicyEvaluationRequest;
import org.gcube.common.vomanagement.security.authorisation.core.PolicyEvaluationResponse;
import org.gcube.common.vomanagement.security.authorisation.core.PolicySerializationException;
import org.gcube.common.vomanagement.security.authorisation.core.impl.XStreamPolicySerializationHelper;
import org.gcube.common.vomanagement.security.authorisation.impl.simple.GCUBEGenericResourceAuthZPolicyPIP;
import org.gcube.common.vomanagement.security.authorisation.impl.simple.GHNCredentials;

public class TrustedPortalPolicy
implements GCUBEPolicy {
    protected GCUBELog logger = new GCUBELog((Object)this);
    private Set<GHNCredentials> trustedPortalsCredentials = new HashSet<GHNCredentials>();
    private XStreamPolicySerializationHelper helper = new XStreamPolicySerializationHelper(new XStream());
    private Map<String, String> paramsMap = new HashMap<String, String>();
    private GCUBEGenericResourceAuthZPolicyPIP genResAuthZPolicyPIP;
    private GCUBEServiceContext context;
    private String serviceClass;
    private String serviceName;

    public Set<GHNCredentials> getTrustedPortals() {
        return this.trustedPortalsCredentials;
    }

    public void setTrustedPortals(Set<GHNCredentials> trustedPortals) {
        this.trustedPortalsCredentials = trustedPortals;
    }

    @Override
    public void initialise(GCUBEServiceContext context) throws Exception {
        this.logger.info((Object)("initialising TrustedPortalPolicy for service " + context.getServiceClass() + ":" + context.getName()));
        this.context = context;
        this.serviceClass = context.getServiceClass();
        this.serviceName = context.getName();
        this.genResAuthZPolicyPIP = GCUBEGenericResourceAuthZPolicyPIP.getInstance(context);
    }

    @Override
    public void initialise(GCUBEServiceContext context, String policyContent) throws Exception {
        this.paramsMap = this.helper.getParameters(policyContent);
        this.initialise(context);
    }

    @Override
    public PolicyEvaluationResponse evaluate(PolicyEvaluationRequest authzRequest) throws PolicyEvaluationException {
        List<GHNCredentials> portalCredentials = this.genResAuthZPolicyPIP.getPortalCredentials(this.context.getScope());
        List<String> allowedOperationsFromPortal = this.genResAuthZPolicyPIP.getTrustedPortalPolicies(this.context.getScope(), this.serviceClass + ":" + this.serviceName);
        String operationRequested = authzRequest.getActionAttributes().get("action.name");
        String dn = authzRequest.getSubjectAttributes().get("subject.dn");
        String ca = authzRequest.getSubjectAttributes().get("subject.ca");
        GHNCredentials callerCredentials = new GHNCredentials(dn, ca);
        this.logger.info((Object)("The caller service " + callerCredentials + " is requesting to invoke " + operationRequested));
        if (allowedOperationsFromPortal.contains(operationRequested)) {
            this.logger.info((Object)("The operation requested (" + operationRequested + ") can be invoked only by trusted portals."));
            if (portalCredentials.contains(callerCredentials)) {
                this.logger.info((Object)("The caller " + callerCredentials + " is a trusted portal, and is authorised to invoke: " + operationRequested));
                return new GCUBEPolicyEvaluationResponse(PolicyEvaluationResponse.RESPONSE.PERMIT);
            }
            this.logger.info((Object)("The caller " + callerCredentials + " is not a trusted portal, and is NOT authorised to invoke: " + operationRequested));
            return new GCUBEPolicyEvaluationResponse(PolicyEvaluationResponse.RESPONSE.DENY);
        }
        this.logger.info((Object)("The caller service " + callerCredentials + " is NOT authorised to invoke " + operationRequested));
        return new GCUBEPolicyEvaluationResponse(PolicyEvaluationResponse.RESPONSE.DENY);
    }

    public String toString() {
        return "TrustedPortal";
    }

    @Override
    public String serialize() throws PolicySerializationException {
        return this.helper.getPolicyExpression(this.getClass().getCanonicalName(), null);
    }
}

